/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.config.remote.request.ClientConfigMetricRequest;
import com.alibaba.nacos.api.config.remote.response.ClientConfigMetricResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/metrics"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ClientMetricsController {
    private final ServerMemberManager serverMemberManager;
    private final ConnectionManager connectionManager;

    public ClientMetricsController(ServerMemberManager serverMemberManager, ConnectionManager connectionManager) {
        this.serverMemberManager = serverMemberManager;
        this.connectionManager = connectionManager;
    }

    @GetMapping(value={"/cluster"})
    @Secured(resource="/v1/cs/metrics", action=ActionTypes.READ, signType="config")
    public ResponseEntity metric(@RequestParam(value="ip") String ip, @RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="tenant", required=false) String tenant) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "default", "default");
        Loggers.CORE.info("Get cluster config metrics received, ip={},dataId={},group={},tenant={}", new Object[]{ip, dataId, group, tenant});
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        Collection members = this.serverMemberManager.allMembers();
        NacosAsyncRestTemplate nacosAsyncRestTemplate = HttpClientBeanHolder.getNacosAsyncRestTemplate((Logger)Loggers.CLUSTER);
        CountDownLatch latch = new CountDownLatch(members.size());
        for (Member member : members) {
            String url = HttpUtils.buildUrl((boolean)false, (String)member.getAddress(), (String[])new String[]{EnvUtil.getContextPath(), "/v1/cs/metrics", "current"});
            Query query = Query.newInstance().addParam("ip", (Object)ip).addParam("dataId", (Object)dataId).addParam("group", (Object)group).addParam("tenant", (Object)tenant);
            nacosAsyncRestTemplate.get(url, Header.EMPTY, query, new GenericType<Map>(){}.getType(), (Callback)new ClusterMetricsCallBack(responseMap, latch, dataId, group, tenant, ip, member));
        }
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ResponseEntity.ok().body(responseMap);
    }

    @GetMapping(value={"/current"})
    @Secured(resource="/v1/cs/metrics", action=ActionTypes.READ, signType="config")
    public Map<String, Object> getClientMetrics(@RequestParam(value="ip") String ip, @RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="tenant", required=false) String tenant) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "default", "default");
        HashMap<String, Object> metrics = new HashMap<String, Object>(16);
        List connectionsByIp = this.connectionManager.getConnectionByIp(ip);
        for (Connection connectionByIp : connectionsByIp) {
            try {
                ClientConfigMetricRequest clientMetrics = new ClientConfigMetricRequest();
                if (StringUtils.isNotBlank((String)dataId)) {
                    clientMetrics.getMetricsKeys().add(ClientConfigMetricRequest.MetricsKey.build((String)"cacheData", (String)GroupKey2.getKey(dataId, group, tenant)));
                    clientMetrics.getMetricsKeys().add(ClientConfigMetricRequest.MetricsKey.build((String)"snapshotData", (String)GroupKey2.getKey(dataId, group, tenant)));
                }
                ClientConfigMetricResponse request1 = (ClientConfigMetricResponse)connectionByIp.request((Request)clientMetrics, 1000L);
                metrics.putAll(request1.getMetrics());
            }
            catch (Exception e) {
                Loggers.CORE.error("Get config metrics error from client ip={},dataId={},group={},tenant={},error={}", new Object[]{ip, dataId, group, tenant, e});
            }
        }
        return metrics;
    }

    static class ClusterMetricsCallBack
    implements Callback<Map> {
        Map<String, Object> responseMap;
        CountDownLatch latch;
        String dataId;
        String group;
        String tenant;
        String ip;
        Member member;

        public ClusterMetricsCallBack(Map<String, Object> responseMap, CountDownLatch latch, String dataId, String group, String tenant, String ip, Member member) {
            this.responseMap = responseMap;
            this.latch = latch;
            this.dataId = dataId;
            this.group = group;
            this.tenant = tenant;
            this.member = member;
            this.ip = ip;
        }

        public void onReceive(RestResult<Map> result) {
            if (result.ok()) {
                this.responseMap.putAll((Map)result.getData());
            }
            this.latch.countDown();
        }

        public void onError(Throwable throwable) {
            Loggers.CORE.error("Get config metrics error from member address={}, ip={},dataId={},group={},tenant={},error={}", new Object[]{this.member.getAddress(), this.ip, this.dataId, this.group, this.tenant, throwable});
            this.latch.countDown();
        }

        public void onCancel() {
            this.latch.countDown();
        }
    }
}

