/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class ParamUtils {
    private static char[] validChars = new char[]{'_', '-', '.', ':'};
    private static final int TAG_MAX_LEN = 16;
    private static final int TENANT_MAX_LEN = 128;
    private static final String CONFIG_TAGS = "config_tags";
    private static final String DESC = "desc";
    private static final String USE = "use";
    private static final String EFFECT = "effect";
    private static final String TYPE = "type";
    private static final String SCHEMA = "schema";
    private static final String ENCRYPTED_DATA_KEY = "encryptedDataKey";

    public static boolean isValid(String param) {
        if (param == null) {
            return false;
        }
        int length = param.length();
        for (int i = 0; i < length; ++i) {
            char ch = param.charAt(i);
            if (Character.isLetterOrDigit(ch) || ParamUtils.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        for (char c : validChars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static void checkParam(String dataId, String group, String datumId, String content) throws NacosException {
        if (StringUtils.isBlank((CharSequence)dataId) || !ParamUtils.isValid(dataId.trim())) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid dataId : " + dataId);
        }
        if (StringUtils.isBlank((CharSequence)group) || !ParamUtils.isValid(group)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid group : " + group);
        }
        if (StringUtils.isBlank((CharSequence)datumId) || !ParamUtils.isValid(datumId)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid datumId : " + datumId);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "content is blank : " + content);
        }
        if (content.length() > PropertyUtil.getMaxContent()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid content, over " + PropertyUtil.getMaxContent());
        }
    }

    public static void checkParam(String dataId, String group, String namespaceId) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)dataId) || !ParamUtils.isValid(dataId.trim())) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid dataId : " + dataId);
        }
        if (StringUtils.isBlank((CharSequence)group) || !ParamUtils.isValid(group)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid group : " + group);
        }
        ParamUtils.checkTenantV2(namespaceId);
    }

    public static void checkParam(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            if (!ParamUtils.isValid(tag.trim())) {
                throw new IllegalArgumentException("invalid tag : " + tag);
            }
            if (tag.length() > 16) {
                throw new IllegalArgumentException("too long tag, over 16");
            }
        }
    }

    public static void checkParam(Map<String, Object> configAdvanceInfo) throws NacosException {
        for (Map.Entry<String, Object> configAdvanceInfoTmp : configAdvanceInfo.entrySet()) {
            if (CONFIG_TAGS.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null) continue;
                String[] tagArr = ((String)configAdvanceInfoTmp.getValue()).split(",");
                if (tagArr.length > 5) {
                    throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too much config_tags, over 5");
                }
                for (String tag : tagArr) {
                    if (tag.length() <= 64) continue;
                    throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long tag, over 64");
                }
                continue;
            }
            if (DESC.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 128) continue;
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long desc, over 128");
            }
            if (USE.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long use, over 32");
            }
            if (EFFECT.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long effect, over 32");
            }
            if (TYPE.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long type, over 32");
            }
            if (SCHEMA.equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32768) continue;
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long schema, over 32768");
            }
            if (ENCRYPTED_DATA_KEY.equals(configAdvanceInfoTmp.getKey())) continue;
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid param");
        }
    }

    public static void checkParamV2(String tag) throws NacosApiException {
        if (StringUtils.isNotBlank((String)tag)) {
            if (!ParamUtils.isValid(tag.trim())) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid tag : " + tag);
            }
            if (tag.length() > 16) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long tag, over 16");
            }
        }
    }

    public static void checkTenant(String tenant) {
        if (StringUtils.isNotBlank((String)tenant)) {
            if (!ParamUtils.isValid(tenant.trim())) {
                throw new IllegalArgumentException("invalid tenant");
            }
            if (tenant.length() > 128) {
                throw new IllegalArgumentException("too long tenant, over 128");
            }
        }
    }

    public static void checkTenantV2(String namespaceId) throws NacosApiException {
        if (StringUtils.isNotBlank((String)namespaceId)) {
            if (!ParamUtils.isValid(namespaceId.trim())) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "invalid namespaceId");
            }
            if (namespaceId.length() > 128) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_VALIDATE_ERROR, "too long namespaceId, over 128");
            }
        }
    }
}

