/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class InMemoryRateLimiterRegistry
implements RateLimiterRegistry {
    private static final String NAME_MUST_NOT_BE_NULL = "Name must not be null";
    private static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    private static final String SUPPLIER_MUST_NOT_BE_NULL = "Supplier must not be null";
    private final RateLimiterConfig defaultRateLimiterConfig;
    private final Map<String, RateLimiter> rateLimiters;

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultRateLimiterConfig) {
        this.defaultRateLimiterConfig = Objects.requireNonNull(defaultRateLimiterConfig, CONFIG_MUST_NOT_BE_NULL);
        this.rateLimiters = new ConcurrentHashMap<String, RateLimiter>();
    }

    @Override
    public Seq<RateLimiter> getAllRateLimiters() {
        return Array.ofAll(this.rateLimiters.values());
    }

    @Override
    public RateLimiter rateLimiter(String name) {
        return this.rateLimiter(name, this.defaultRateLimiterConfig);
    }

    @Override
    public RateLimiter rateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL);
        Objects.requireNonNull(rateLimiterConfig, CONFIG_MUST_NOT_BE_NULL);
        return this.rateLimiters.computeIfAbsent(name, limitName -> new AtomicRateLimiter(name, rateLimiterConfig));
    }

    @Override
    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL);
        Objects.requireNonNull(rateLimiterConfigSupplier, SUPPLIER_MUST_NOT_BE_NULL);
        return this.rateLimiters.computeIfAbsent(name, limitName -> {
            RateLimiterConfig rateLimiterConfig = (RateLimiterConfig)rateLimiterConfigSupplier.get();
            Objects.requireNonNull(rateLimiterConfig, CONFIG_MUST_NOT_BE_NULL);
            return new AtomicRateLimiter((String)limitName, rateLimiterConfig);
        });
    }
}

