/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.configure.BulkheadAspectExt;
import io.github.resilience4j.bulkhead.configure.BulkheadConfigurationProperties;
import io.github.resilience4j.utils.AnnotationExtractor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class BulkheadAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(BulkheadAspect.class);
    private final BulkheadConfigurationProperties bulkheadConfigurationProperties;
    private final BulkheadRegistry bulkheadRegistry;
    private final List<BulkheadAspectExt> bulkheadAspectExts;

    public BulkheadAspect(BulkheadConfigurationProperties backendMonitorPropertiesRegistry, BulkheadRegistry bulkheadRegistry, @Autowired(required=false) List<BulkheadAspectExt> bulkheadAspectExts) {
        this.bulkheadConfigurationProperties = backendMonitorPropertiesRegistry;
        this.bulkheadRegistry = bulkheadRegistry;
        this.bulkheadAspectExts = bulkheadAspectExts;
    }

    @Pointcut(value="@within(Bulkhead) || @annotation(Bulkhead)", argNames="Bulkhead")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.bulkhead.annotation.Bulkhead Bulkhead2) {
    }

    @Around(value="matchAnnotatedClassOrMethod(backendMonitored)", argNames="proceedingJoinPoint, backendMonitored")
    public Object bulkheadAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, io.github.resilience4j.bulkhead.annotation.Bulkhead backendMonitored) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (backendMonitored == null) {
            backendMonitored = this.getBackendMonitoredAnnotation(proceedingJoinPoint);
        }
        String backend = backendMonitored.name();
        Bulkhead bulkhead = this.getOrCreateBulkhead(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (this.bulkheadAspectExts != null && !this.bulkheadAspectExts.isEmpty()) {
            for (BulkheadAspectExt bulkHeadAspectExt : this.bulkheadAspectExts) {
                if (!bulkHeadAspectExt.canHandleReturnType(returnType)) continue;
                return bulkHeadAspectExt.handle(proceedingJoinPoint, bulkhead, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, bulkhead, methodName);
        }
        return this.handleJoinPoint(proceedingJoinPoint, bulkhead, methodName);
    }

    private Bulkhead getOrCreateBulkhead(String methodName, String backend) {
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(backend, () -> this.bulkheadConfigurationProperties.createBulkheadConfig(backend));
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved bulkhead '{}' with max concurrent call '{}' and max wait time '{}' for method: '{}'", new Object[]{backend, bulkhead.getBulkheadConfig().getMaxConcurrentCalls(), bulkhead.getBulkheadConfig().getMaxWaitTime(), methodName});
        }
        return bulkhead;
    }

    private io.github.resilience4j.bulkhead.annotation.Bulkhead getBackendMonitoredAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("bulkhead parameter is null");
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead, String methodName) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("bulkhead method invocation for method {}", (Object)methodName);
        }
        return bulkhead.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead, String methodName) throws Throwable {
        return bulkhead.executeCompletionStage(() -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                logger.error("Exception being thrown during bulkhead invocation {} ", (Object)methodName, (Object)throwable.getCause());
                throw new CompletionException(throwable);
            }
        });
    }

    public int getOrder() {
        return this.bulkheadConfigurationProperties.getBulkheadAspectOrder();
    }
}

