/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.beans.BeanUtils;

public class CircuitBreakerConfigurationProperties {
    private int circuitBreakerAspectOrder = 0x7FFFFFFE;
    private Map<String, BackendProperties> backends = new HashMap<String, BackendProperties>();

    public int getCircuitBreakerAspectOrder() {
        return this.circuitBreakerAspectOrder;
    }

    public void setCircuitBreakerAspectOrder(int circuitBreakerAspectOrder) {
        this.circuitBreakerAspectOrder = circuitBreakerAspectOrder;
    }

    private BackendProperties getBackendProperties(String backend) {
        return this.backends.get(backend);
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(String backend) {
        return this.createCircuitBreakerConfig(this.getBackendProperties(backend));
    }

    private CircuitBreakerConfig createCircuitBreakerConfig(BackendProperties backendProperties) {
        return this.buildCircuitBreakerConfig(backendProperties).build();
    }

    public CircuitBreakerConfig.Builder buildCircuitBreakerConfig(@Nullable BackendProperties properties) {
        if (properties == null) {
            return new CircuitBreakerConfig.Builder();
        }
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom();
        if (properties.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(properties.getWaitDurationInOpenState());
        }
        if (properties.getFailureRateThreshold() != null) {
            builder.failureRateThreshold((float)properties.getFailureRateThreshold().intValue());
        }
        if (properties.getRingBufferSizeInClosedState() != null) {
            builder.ringBufferSizeInClosedState(properties.getRingBufferSizeInClosedState().intValue());
        }
        if (properties.getRingBufferSizeInHalfOpenState() != null) {
            builder.ringBufferSizeInHalfOpenState(properties.getRingBufferSizeInHalfOpenState().intValue());
        }
        if (properties.recordFailurePredicate != null) {
            this.buildRecordFailurePredicate(properties, builder);
        }
        if (properties.recordExceptions != null) {
            builder.recordExceptions(properties.recordExceptions);
        }
        if (properties.ignoreExceptions != null) {
            builder.ignoreExceptions(properties.ignoreExceptions);
        }
        if (properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue()) {
            builder.enableAutomaticTransitionFromOpenToHalfOpen();
        }
        return builder;
    }

    protected void buildRecordFailurePredicate(BackendProperties properties, CircuitBreakerConfig.Builder builder) {
        builder.recordFailure((Predicate)BeanUtils.instantiateClass(properties.getRecordFailurePredicate()));
    }

    public Map<String, BackendProperties> getBackends() {
        return this.backends;
    }

    public static class BackendProperties {
        @DurationMin(seconds=1L)
        @Nullable
        private @DurationMin(seconds=1L) Duration waitDurationInOpenState;
        @Min(value=1L)
        @Max(value=100L)
        @Nullable
        private @Min(value=1L) @Max(value=100L) Integer failureRateThreshold;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInClosedState;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInHalfOpenState;
        @NotNull
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
        @Min(value=1L)
        private @Min(value=1L) Integer eventConsumerBufferSize = 100;
        @NotNull
        private Boolean registerHealthIndicator = true;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;

        @Deprecated
        public void setWaitInterval(Integer waitInterval) {
            this.waitDurationInOpenState = Duration.ofMillis(waitInterval.intValue());
        }

        @Nullable
        public Integer getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public void setFailureRateThreshold(Integer failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public void setWaitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState = waitDurationInOpenState;
        }

        @Nullable
        public Integer getRingBufferSizeInClosedState() {
            return this.ringBufferSizeInClosedState;
        }

        public void setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
        }

        @Nullable
        public Integer getRingBufferSizeInHalfOpenState() {
            return this.ringBufferSizeInHalfOpenState;
        }

        public void setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public void setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public void setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public void setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public void setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public void setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
        }
    }
}

