/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorCircuitBreakerAspectExt
implements CircuitBreakerAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(ReactorCircuitBreakerAspectExt.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker));
        }
        logger.error("Unsupported type for Reactor circuit breaker {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the circuit breaker in Reactor:" + returnValue.getClass().getName());
    }
}

