/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.utils.AnnotationExtractor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class RateLimiterAspect
implements Ordered {
    public static final String RATE_LIMITER_RECEIVED = "Created or retrieved rate limiter '{}' with period: '{}'; limit for period: '{}'; timeout: '{}'; method: '{}'";
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterAspect.class);
    private final RateLimiterRegistry rateLimiterRegistry;
    private final RateLimiterConfigurationProperties properties;
    private final List<RateLimiterAspectExt> rateLimiterAspectExtList;

    public RateLimiterAspect(RateLimiterRegistry rateLimiterRegistry, RateLimiterConfigurationProperties properties, @Autowired(required=false) List<RateLimiterAspectExt> rateLimiterAspectExtList) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.properties = properties;
        this.rateLimiterAspectExtList = rateLimiterAspectExtList;
    }

    @Pointcut(value="@within(rateLimiter) || @annotation(rateLimiter)", argNames="rateLimiter")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.ratelimiter.annotation.RateLimiter rateLimiter) {
    }

    @Around(value="matchAnnotatedClassOrMethod(limitedService)", argNames="proceedingJoinPoint, limitedService")
    public Object rateLimiterAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, io.github.resilience4j.ratelimiter.annotation.RateLimiter limitedService) throws Throwable {
        io.github.resilience4j.ratelimiter.annotation.RateLimiter targetService = limitedService;
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (targetService == null) {
            targetService = this.getRateLimiterAnnotation(proceedingJoinPoint);
        }
        String name = targetService.name();
        Class<?> returnType = method.getReturnType();
        RateLimiter rateLimiter = this.getOrCreateRateLimiter(methodName, name);
        if (this.rateLimiterAspectExtList != null && !this.rateLimiterAspectExtList.isEmpty()) {
            for (RateLimiterAspectExt rateLimiterAspectExt : this.rateLimiterAspectExtList) {
                if (!rateLimiterAspectExt.canHandleReturnType(returnType)) continue;
                return rateLimiterAspectExt.handle(proceedingJoinPoint, rateLimiter, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, rateLimiter, methodName);
        }
        return this.handleJoinPoint(proceedingJoinPoint, rateLimiter, methodName);
    }

    private RateLimiter getOrCreateRateLimiter(String methodName, String name) {
        RateLimiter rateLimiter = this.rateLimiterRegistry.rateLimiter(name);
        if (logger.isDebugEnabled()) {
            RateLimiterConfig rateLimiterConfig = rateLimiter.getRateLimiterConfig();
            logger.debug(RATE_LIMITER_RECEIVED, new Object[]{name, rateLimiterConfig.getLimitRefreshPeriod(), rateLimiterConfig.getLimitForPeriod(), rateLimiterConfig.getTimeoutDuration(), methodName});
        }
        return rateLimiter;
    }

    private io.github.resilience4j.ratelimiter.annotation.RateLimiter getRateLimiterAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.ratelimiter.annotation.RateLimiter.class);
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter, String methodName) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("Rate limiter invocation for method {} ", (Object)methodName);
        }
        return rateLimiter.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter, String methodName) {
        return RateLimiter.decorateCompletionStage((RateLimiter)rateLimiter, () -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                logger.error("Exception being thrown during RateLimiter invocation {} ", (Object)methodName, (Object)throwable.getCause());
                throw new CompletionException(throwable);
            }
        }).get();
    }

    public int getOrder() {
        return this.properties.getRateLimiterAspectOrder();
    }
}

