/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspect;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.configure.ReactorRateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RxJava2RateLimterAspectExt;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RateLimiterConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterConfiguration.class);

    @Bean
    public RateLimiterRegistry rateLimiterRegistry(RateLimiterConfigurationProperties rateLimiterProperties, EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry, ConfigurableBeanFactory beanFactory) {
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of((RateLimiterConfig)RateLimiterConfig.ofDefaults());
        rateLimiterProperties.getLimiters().forEach((name, properties) -> {
            RateLimiter rateLimiter = this.createRateLimiter(rateLimiterRegistry, (String)name, (RateLimiterConfigurationProperties.LimiterProperties)properties);
            if (properties.getSubscribeForEvents().booleanValue()) {
                this.subscribeToLimiterEvents(rateLimiterEventsConsumerRegistry, (String)name, (RateLimiterConfigurationProperties.LimiterProperties)properties, rateLimiter);
            }
        });
        return rateLimiterRegistry;
    }

    @Bean
    public RateLimiterAspect rateLimiterAspect(RateLimiterConfigurationProperties rateLimiterProperties, RateLimiterRegistry rateLimiterRegistry, @Autowired(required=false) List<RateLimiterAspectExt> rateLimiterAspectExtList) {
        return new RateLimiterAspect(rateLimiterRegistry, rateLimiterProperties, rateLimiterAspectExtList);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class})
    public RxJava2RateLimterAspectExt rxJava2RateLimterAspectExt() {
        return new RxJava2RateLimterAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class})
    public ReactorRateLimiterAspectExt reactorRateLimiterAspectExt() {
        return new ReactorRateLimiterAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private void subscribeToLimiterEvents(EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry, String name, RateLimiterConfigurationProperties.LimiterProperties properties, RateLimiter rateLimiter) {
        CircularEventConsumer eventConsumer = rateLimiterEventsConsumerRegistry.createEventConsumer(name, properties.getEventConsumerBufferSize().intValue());
        rateLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumer);
        logger.debug("Autoconfigure subscription for Rate Limiter {}", (Object)rateLimiter);
    }

    private RateLimiter createRateLimiter(RateLimiterRegistry rateLimiterRegistry, String name, RateLimiterConfigurationProperties.LimiterProperties properties) {
        RateLimiter rateLimiter = rateLimiterRegistry.rateLimiter(name, RateLimiterConfigurationProperties.createRateLimiterConfig(properties));
        logger.debug("Autoconfigure Rate Limiter registered. {}", (Object)rateLimiter);
        return rateLimiter;
    }
}

