/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.retry.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.beans.BeanUtils;

public class RetryConfigurationProperties {
    private final Map<String, BackendProperties> backends = new HashMap<String, BackendProperties>();
    private int retryAspectOrder = 0x7FFFFFFC;

    public RetryConfig createRetryConfig(String backend) {
        return this.createRetryConfig(this.getBackendProperties(backend));
    }

    public int getRetryAspectOrder() {
        return this.retryAspectOrder;
    }

    public void setRetryAspectOrder(int retryAspectOrder) {
        this.retryAspectOrder = retryAspectOrder;
    }

    public Map<String, BackendProperties> getBackends() {
        return this.backends;
    }

    private RetryConfig createRetryConfig(BackendProperties backendProperties) {
        return this.buildRetryConfig(backendProperties).build();
    }

    private BackendProperties getBackendProperties(String backend) {
        return this.backends.get(backend);
    }

    public RetryConfig.Builder buildRetryConfig(BackendProperties properties) {
        if (properties == null) {
            return new RetryConfig.Builder();
        }
        RetryConfig.Builder builder = RetryConfig.custom();
        if (properties.enableExponentialBackoff.booleanValue() && properties.enableRandomizedWait.booleanValue()) {
            throw new IllegalStateException("you can not enable Exponential backoff policy and randomized delay at the same time , please enable only one of them");
        }
        this.configureRetryIntervalFunction(properties, (RetryConfig.Builder<Object>)builder);
        if (properties.getMaxRetryAttempts() != 0) {
            builder.maxAttempts(properties.getMaxRetryAttempts().intValue());
        }
        if (properties.getRetryExceptionPredicate() != null) {
            builder.retryOnException((Predicate)BeanUtils.instantiateClass(properties.getRetryExceptionPredicate()));
        }
        if (properties.getIgnoreExceptions() != null) {
            builder.ignoreExceptions((Class[])properties.getIgnoreExceptions());
        }
        if (properties.getRetryExceptions() != null) {
            builder.retryExceptions((Class[])properties.getRetryExceptions());
        }
        if (properties.getResultPredicate() != null) {
            builder.retryOnResult((Predicate)BeanUtils.instantiateClass(properties.getResultPredicate()));
        }
        return builder;
    }

    private void configureRetryIntervalFunction(BackendProperties properties, RetryConfig.Builder<Object> builder) {
        if (properties.getWaitDuration() != 0L) {
            long waitDuration = properties.getWaitDuration();
            if (properties.getEnableExponentialBackoff().booleanValue()) {
                if (properties.getExponentialBackoffMultiplier() != 0.0) {
                    builder.intervalFunction(IntervalFunction.ofExponentialBackoff((long)waitDuration, (double)properties.getExponentialBackoffMultiplier()));
                } else {
                    builder.intervalFunction(IntervalFunction.ofExponentialBackoff((long)properties.getWaitDuration()));
                }
            } else if (properties.getEnableRandomizedWait().booleanValue()) {
                if (properties.getRandomizedWaitFactor() != 0.0) {
                    builder.intervalFunction(IntervalFunction.ofRandomized((long)waitDuration, (double)properties.getRandomizedWaitFactor()));
                } else {
                    builder.intervalFunction(IntervalFunction.ofRandomized((long)waitDuration));
                }
            } else {
                builder.waitDuration(Duration.ofMillis(properties.getWaitDuration()));
            }
        }
    }

    public static class BackendProperties {
        @Min(value=100L)
        private @Min(value=100L) Long waitDuration;
        @Min(value=1L)
        private @Min(value=1L) Integer maxRetryAttempts;
        private Class<? extends Predicate<Throwable>> retryExceptionPredicate;
        private Class<? extends Predicate> resultPredicate;
        private Class<? extends Throwable>[] retryExceptions;
        private Class<? extends Throwable>[] ignoreExceptions;
        @Min(value=1L)
        private @Min(value=1L) Integer eventConsumerBufferSize = 100;
        @NotNull
        private Boolean enableExponentialBackoff = false;
        private double exponentialBackoffMultiplier;
        @NotNull
        private Boolean enableRandomizedWait = false;
        private double randomizedWaitFactor;

        public Long getWaitDuration() {
            return this.waitDuration;
        }

        public void setWaitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
        }

        public Integer getMaxRetryAttempts() {
            return this.maxRetryAttempts;
        }

        public void setMaxRetryAttempts(Integer maxRetryAttempts) {
            this.maxRetryAttempts = maxRetryAttempts;
        }

        public Class<? extends Predicate<Throwable>> getRetryExceptionPredicate() {
            return this.retryExceptionPredicate;
        }

        public void setRetryExceptionPredicate(Class<? extends Predicate<Throwable>> retryExceptionPredicate) {
            this.retryExceptionPredicate = retryExceptionPredicate;
        }

        public Class<? extends Predicate> getResultPredicate() {
            return this.resultPredicate;
        }

        public void setResultPredicate(Class<? extends Predicate> resultPredicate) {
            this.resultPredicate = resultPredicate;
        }

        public Class<? extends Throwable>[] getRetryExceptions() {
            return this.retryExceptions;
        }

        public void setRetryExceptions(Class<? extends Throwable>[] retryExceptions) {
            this.retryExceptions = retryExceptions;
        }

        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public void setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        public Boolean getEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public void setEnableExponentialBackoff(Boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
        }

        public double getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public void setExponentialBackoffMultiplier(double exponentialBackoffMultiplier) {
            this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
        }

        public Boolean getEnableRandomizedWait() {
            return this.enableRandomizedWait;
        }

        public void setEnableRandomizedWait(Boolean enableRandomizedWait) {
            this.enableRandomizedWait = enableRandomizedWait;
        }

        public double getRandomizedWaitFactor() {
            return this.randomizedWaitFactor;
        }

        public void setRandomizedWaitFactor(double randomizedWaitFactor) {
            this.randomizedWaitFactor = randomizedWaitFactor;
        }
    }
}

