/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.utils;

import io.github.resilience4j.utils.AspectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ReactorOnClasspathCondition
implements Condition {
    private static final Logger logger = LoggerFactory.getLogger(ReactorOnClasspathCondition.class);
    private static final String CLASS_TO_CHECK = "reactor.core.publisher.Flux";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return AspectUtil.checkClassIfFound(context, CLASS_TO_CHECK, e -> logger.info("Reactor related Aspect extensions are not activated because Reactor is not on the classpath."));
    }
}

