/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup;

import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.builder.Swagger2MarkupConfigBuilder;
import io.github.swagger2markup.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convertSwagger2markup")
public class Swagger2MarkupMojo
extends AbstractMojo {
    @Parameter(property="swaggerInput", required=true)
    protected String swaggerInput;
    @Parameter(property="outputDir")
    protected File outputDir;
    @Parameter(property="outputFile")
    protected File outputFile;
    @Parameter
    protected Map<String, String> config = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        block6: {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"convertSwagger2markup goal started");
                this.getLog().debug((CharSequence)("swaggerInput: " + this.swaggerInput));
                this.getLog().debug((CharSequence)("outputDir: " + this.outputDir));
                this.getLog().debug((CharSequence)("outputFile: " + this.outputFile));
                for (Map.Entry<String, String> entry : this.config.entrySet()) {
                    this.getLog().debug((CharSequence)(entry.getKey() + ": " + entry.getValue()));
                }
            }
            try {
                Swagger2MarkupConfig swagger2MarkupConfig = new Swagger2MarkupConfigBuilder(this.config).build();
                Swagger2MarkupConverter converter = Swagger2MarkupConverter.from((URI)URIUtils.create((String)this.swaggerInput)).withConfig(swagger2MarkupConfig).build();
                if (this.outputFile != null) {
                    converter.toFile(this.outputFile.toPath());
                    break block6;
                }
                if (this.outputDir != null) {
                    converter.toFolder(this.outputDir.toPath());
                    break block6;
                }
                throw new IllegalArgumentException("Either outputFile or outputDir parameter must be used");
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to execute goal 'convertSwagger2markup'", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)"convertSwagger2markup goal finished");
    }
}

