/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.ReflectionHint;
import io.goodforgod.graalvm.hint.processor.AbstractHintProcessor;
import io.goodforgod.graalvm.hint.processor.HintFile;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

abstract class AbstractAccessHintProcessor
extends AbstractHintProcessor {
    private static final String ALL_PUBLIC_CONSTRUCTORS = "allPublicConstructors";
    private static final String ALL_PUBLIC_FIELDS = "allPublicFields";
    private static final String ALL_PUBLIC_METHODS = "allPublicMethods";
    private static final String ALL_DECLARED_CONSTRUCTORS = "allDeclaredConstructors";
    private static final String ALL_DECLARED_FIELDS = "allDeclaredFields";
    private static final String ALL_DECLARED_METHODS = "allDeclaredMethods";
    private static final String NAME = "name";

    AbstractAccessHintProcessor() {
    }

    protected abstract String getFileName();

    protected abstract List<Access> getAccessForElement(TypeElement var1);

    protected Set<TypeElement> getAnnotatedTypeElements(RoundEnvironment roundEnv) {
        Class[] classes = (Class[])this.getSupportedAnnotations().toArray(Class[]::new);
        return HintUtils.getAnnotatedElements(roundEnv, classes);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        try {
            Set<TypeElement> types = this.getAnnotatedTypeElements(roundEnv);
            HashMap<HintOrigin, Set> accessHints = new HashMap<HintOrigin, Set>();
            for (TypeElement typeElement : types) {
                List<Access> typeAccesses = this.getAccessForElement(typeElement);
                if (typeAccesses.isEmpty()) continue;
                HintOrigin origin = HintUtils.getHintOrigin(typeElement, this.processingEnv);
                Set accesses = accessHints.computeIfAbsent(origin, k -> new LinkedHashSet());
                accesses.addAll(typeAccesses);
            }
            for (Map.Entry entry : accessHints.entrySet()) {
                String configJson = this.getAccessConfigJson((Collection)entry.getValue());
                HintFile file = ((HintOrigin)entry.getKey()).getFileWithRelativePath(this.getFileName());
                if (HintUtils.writeConfigFile(file, configJson, this.processingEnv)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private String getAccessConfigJson(Collection<Access> accesses) {
        return accesses.stream().sorted(Comparator.comparing(a -> a.typeName)).map(AbstractAccessHintProcessor::getGraalReflectionForTypeName).map(AbstractAccessHintProcessor::mapToJson).collect(Collectors.joining(",\n", "[", "]"));
    }

    private static String mapToJson(Map<String, Object> map) {
        return map.entrySet().stream().map(e -> e.getValue() instanceof String ? String.format("\"%s\": \"%s\"", e.getKey(), e.getValue()) : String.format("\"%s\": %s", e.getKey(), e.getValue())).collect(Collectors.joining(",\n  ", "{\n  ", "\n}"));
    }

    private static Map<String, Object> getGraalReflectionForTypeName(Access access) {
        LinkedHashMap<String, Object> reflectionMap = new LinkedHashMap<String, Object>(access.accessTypes.length + 3);
        String typeFinalName = AbstractAccessHintProcessor.isTypeInnerClass(access.typeName) ? AbstractAccessHintProcessor.getInnerTypeName(access.typeName) : access.typeName;
        reflectionMap.put(NAME, typeFinalName);
        Arrays.stream(access.accessTypes).flatMap(accessType -> AbstractAccessHintProcessor.getGraalAccessType(accessType).stream()).distinct().sorted().forEach(graalAccessType -> reflectionMap.put((String)graalAccessType, true));
        return reflectionMap;
    }

    private static boolean isTypeInnerClass(String typeName) {
        return typeName.endsWith(".class");
    }

    private static String getInnerTypeName(String typeName) {
        String nextClassType;
        int nextSeparator;
        ArrayList<String> classType = new ArrayList<String>();
        String packagePrefix = typeName.substring(0, typeName.length() - 6);
        while ((nextSeparator = packagePrefix.lastIndexOf(46)) != -1 && Character.isUpperCase((nextClassType = packagePrefix.substring(nextSeparator + 1)).charAt(0))) {
            classType.add(nextClassType);
            packagePrefix = packagePrefix.substring(0, nextSeparator);
        }
        Collections.reverse(classType);
        return classType.stream().collect(Collectors.joining("$", packagePrefix + ".", ""));
    }

    private static List<String> getGraalAccessType(ReflectionHint.AccessType accessType) {
        switch (accessType) {
            case ALL_PUBLIC: {
                return List.of(ALL_PUBLIC_CONSTRUCTORS, ALL_PUBLIC_METHODS, ALL_PUBLIC_FIELDS);
            }
            case ALL_PUBLIC_CONSTRUCTORS: {
                return List.of(ALL_PUBLIC_CONSTRUCTORS);
            }
            case ALL_PUBLIC_METHODS: {
                return List.of(ALL_PUBLIC_METHODS);
            }
            case ALL_PUBLIC_FIELDS: {
                return List.of(ALL_PUBLIC_FIELDS);
            }
            case ALL_DECLARED: {
                return List.of(ALL_DECLARED_CONSTRUCTORS, ALL_DECLARED_METHODS, ALL_DECLARED_FIELDS);
            }
            case ALL_DECLARED_CONSTRUCTORS: {
                return List.of(ALL_DECLARED_CONSTRUCTORS);
            }
            case ALL_DECLARED_METHODS: {
                return List.of(ALL_DECLARED_METHODS);
            }
            case ALL_DECLARED_FIELDS: {
                return List.of(ALL_DECLARED_FIELDS);
            }
        }
        throw new IllegalStateException("Unknown AccessType is present: " + accessType);
    }

    static class Access
    implements Comparable<Access> {
        private final String typeName;
        private final ReflectionHint.AccessType[] accessTypes;

        Access(String typeName, ReflectionHint.AccessType[] accessTypes) {
            this.typeName = typeName;
            this.accessTypes = accessTypes;
        }

        @Override
        public int compareTo(Access o) {
            return this.typeName.compareTo(o.typeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Access that = (Access)o;
            return Objects.equals(this.typeName, that.typeName);
        }

        public int hashCode() {
            return Objects.hash(this.typeName);
        }
    }
}

