/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.DynamicProxyHint;
import io.goodforgod.graalvm.hint.processor.HintException;
import io.goodforgod.graalvm.hint.processor.HintFile;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import io.goodforgod.graalvm.hint.processor.Option;
import io.goodforgod.graalvm.hint.processor.OptionParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class DynamicProxyHintParser
implements OptionParser {
    DynamicProxyHintParser() {
    }

    @Override
    public List<Class<? extends Annotation>> getSupportedAnnotations() {
        return List.of(DynamicProxyHint.class);
    }

    @Override
    public List<Option> getOptions(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(DynamicProxyHint.class);
        Set<TypeElement> elements = ElementFilter.typesIn(annotated);
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<HintOrigin, DynamicProxy> proxies = new HashMap<HintOrigin, DynamicProxy>();
        for (TypeElement element : elements) {
            List<String> resources = List.of(element.getAnnotation(DynamicProxyHint.class).resources());
            List<String> files = List.of(element.getAnnotation(DynamicProxyHint.class).files());
            List configurations = this.getDynamicProxyConfigurations(element).stream().filter(c -> !c.getInterfaces().isEmpty()).collect(Collectors.toList());
            if (configurations.isEmpty() && files.isEmpty() && resources.isEmpty()) continue;
            HintOrigin origin = HintUtils.getHintOrigin(element, processingEnv);
            DynamicProxy proxy = proxies.computeIfAbsent(origin, k -> new DynamicProxy());
            proxy.files.addAll(files);
            proxy.resources.addAll(resources);
            proxy.configurations.addAll(configurations);
        }
        proxies.forEach((o, p) -> {
            if (!p.configurations.isEmpty()) {
                String proxyConfigurationFile = p.configurations.stream().map(c -> c.getInterfaces().stream().collect(Collectors.joining("\", \"", "  { \"interfaces\": [ \"", "\" ] }"))).collect(Collectors.joining(",\n", "[\n", "\n]"));
                HintOrigin origin = HintUtils.getHintOrigin((Element)elements.iterator().next(), processingEnv);
                HintFile file = origin.getFileWithRelativePath("dynamic-proxy-config.json");
                HintUtils.writeConfigFile(file, proxyConfigurationFile, processingEnv);
                p.resources.add(file.getPath());
            }
        });
        ArrayList<Option> options = new ArrayList<Option>();
        proxies.forEach((o, p) -> {
            ArrayList<String> originOptions = new ArrayList<String>();
            if (!p.files.isEmpty()) {
                String proxyFileOption = p.files.stream().collect(Collectors.joining(",", "-H:DynamicProxyConfigurationFiles=", ""));
                originOptions.add(proxyFileOption);
            }
            if (!p.resources.isEmpty()) {
                String proxyResourceOption = p.resources.stream().collect(Collectors.joining(",", "-H:DynamicProxyConfigurationResources=", ""));
                originOptions.add(proxyResourceOption);
            }
            options.add(new Option((HintOrigin)o, (List<String>)originOptions));
        });
        return options;
    }

    private List<Configuration> getDynamicProxyConfigurations(TypeElement type) {
        String annotationParent = DynamicProxyHint.class.getSimpleName();
        List<Configuration> interfaceConfigurations = type.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().asElement().getSimpleName().contentEquals(annotationParent)).flatMap(pa -> pa.getElementValues().entrySet().stream()).filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream()).map(a -> {
            List<String> interfaces = HintUtils.getAnnotationFieldValues((AnnotationMirror)a, "interfaces");
            return new Configuration(interfaces);
        }).collect(Collectors.toList());
        if (interfaceConfigurations.isEmpty() && this.isSelfConfiguration(type)) {
            String elementName = HintUtils.getElementClassName(type);
            if (type.getKind().isInterface()) {
                return List.of(new Configuration(List.of(elementName)));
            }
            throw new HintException(elementName + " is annotated with @" + DynamicProxyHint.class.getSimpleName() + " hint but is not an interface", type);
        }
        return interfaceConfigurations;
    }

    private boolean isSelfConfiguration(TypeElement element) {
        DynamicProxyHint annotation = element.getAnnotation(DynamicProxyHint.class);
        return !(annotation.resources() != null && annotation.resources().length != 0 || annotation.files() != null && annotation.files().length != 0);
    }

    private static final class DynamicProxy {
        private final List<String> resources = new ArrayList<String>();
        private final List<String> files = new ArrayList<String>();
        private final List<Configuration> configurations = new ArrayList<Configuration>();

        private DynamicProxy() {
        }
    }

    static class Configuration {
        private final List<String> interfaces;

        private Configuration(List<String> interfaces) {
            this.interfaces = interfaces;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }
    }
}

