/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.processor.HintFile;
import java.util.Objects;

final class HintOrigin {
    public static final String HINT_PROCESSING_GROUP = "graalvm.hint.group";
    public static final String HINT_PROCESSING_ARTIFACT = "graalvm.hint.artifact";
    static final String DEFAULT_PACKAGE = "io.graalvm.hint";
    private final String group;
    private final String artifact;

    HintOrigin(String group, String artifact) {
        this.group = group;
        this.artifact = artifact;
    }

    public HintFile getFileWithRelativePath(String fileName) {
        return this.artifact == null ? new HintFile(fileName, "META-INF/native-image/" + this.group) : new HintFile(fileName, "META-INF/native-image/" + this.group + "/" + this.artifact);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HintOrigin that = (HintOrigin)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.artifact);
    }

    public String toString() {
        return this.artifact == null ? "[group=" + this.group + "]" : "[group=" + this.group + ", artifact=" + this.artifact + "]";
    }
}

