/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.processor.HintFile;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class HintUtils {
    private HintUtils() {
    }

    static HintOrigin getHintOrigin(Element element, ProcessingEnvironment processingEnv) {
        Map<String, String> options = processingEnv.getOptions();
        String group = options.containsKey("graalvm.hint.group") ? options.get("graalvm.hint.group") : HintUtils.getPackage(processingEnv, element);
        String artifact = options.containsKey("graalvm.hint.artifact") ? options.get("graalvm.hint.artifact") : HintUtils.getArtifact(element);
        return new HintOrigin(group, artifact);
    }

    static Set<TypeElement> getAnnotatedElements(RoundEnvironment roundEnv, Class<? extends Annotation> ... annotations) {
        return Arrays.stream(annotations).flatMap(a -> {
            Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith((Class<? extends Annotation>)a);
            if (annotated == null || annotated.isEmpty()) {
                return Stream.empty();
            }
            return ElementFilter.typesIn(annotated).stream();
        }).collect(Collectors.toSet());
    }

    static Optional<String> getAnnotationFieldClassNameAny(TypeElement type, Class<? extends Annotation> annotation, String annotationFieldName) {
        List<String> classNames = HintUtils.getAnnotationFieldClassNames(type, annotation, annotationFieldName);
        return classNames.isEmpty() ? Optional.empty() : Optional.of(classNames.get(0));
    }

    static List<String> getAnnotationFieldClassNames(TypeElement type, Class<? extends Annotation> annotation, String annotationFieldName) {
        String annotationName = annotation.getSimpleName();
        return type.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals(annotationName)).flatMap(a -> HintUtils.getAnnotationFieldValues(a, annotationFieldName).stream()).collect(Collectors.toList());
    }

    static List<String> getAnnotationFieldValuesOrDefault(AnnotationMirror mirror, String annotationFieldName, List<String> defaultValues) {
        List<String> fieldValues = HintUtils.getAnnotationFieldValues(mirror, annotationFieldName);
        return fieldValues.isEmpty() ? defaultValues : fieldValues;
    }

    static List<String> getAnnotationFieldValues(AnnotationMirror mirror, String annotationFieldName) {
        return mirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(annotationFieldName)).flatMap(e -> {
            Object value = ((AnnotationValue)e.getValue()).getValue();
            if (value instanceof Collection) {
                return ((Collection)value).stream().map(HintUtils::getAnnotationValueAsString);
            }
            return Stream.of(HintUtils.getAnnotationValueAsString(value));
        }).filter(e -> !e.isBlank()).collect(Collectors.toList());
    }

    private static String getAnnotationValueAsString(Object v) {
        if (v instanceof AnnotationValue) {
            Object itemValue = ((AnnotationValue)v).getValue();
            if (itemValue instanceof DeclaredType) {
                Element element = ((DeclaredType)itemValue).asElement();
                return HintUtils.getElementClassName(element);
            }
            return itemValue.toString();
        }
        return v.toString();
    }

    static String getElementClassName(Element element) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Element next = element; next != null; next = next.getEnclosingElement()) {
            parts.add(next.getSimpleName().toString());
            if (next instanceof PackageElement) {
                if (((PackageElement)next).isUnnamed()) break;
                parts.add(".");
                parts.add(next.toString());
                break;
            }
            if (next instanceof ModuleElement) break;
            parts.add("$");
        }
        Collections.reverse(parts);
        return String.join((CharSequence)"", parts);
    }

    static boolean writeConfigFile(HintFile file, String data, ProcessingEnvironment processingEnv) {
        try {
            FileObject fileObject = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", file.getPath(), new Element[0]);
            try (Writer writer = fileObject.openWriter();){
                writer.write(data);
            }
        }
        catch (Exception e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Couldn't write GraalVM Hint " + file.getName() + " to due to: " + e.getMessage());
            return false;
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating GraalVM Hint " + file.getName() + " to: " + file.getPath());
        return true;
    }

    private static String getPackage(ProcessingEnvironment processingEnv, Element element) {
        PackageElement packageElement = processingEnv.getElementUtils().getPackageOf(element);
        if (packageElement == null || packageElement.isUnnamed()) {
            return "io.graalvm.hint";
        }
        String packageName = packageElement.getQualifiedName().toString();
        if (packageName.isEmpty()) {
            return "io.graalvm.hint";
        }
        return packageName;
    }

    private static String getArtifact(Element element) {
        return null;
    }
}

