/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.InitializationHint;
import io.goodforgod.graalvm.hint.annotation.InitializationHints;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import io.goodforgod.graalvm.hint.processor.Option;
import io.goodforgod.graalvm.hint.processor.OptionParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;

final class InitializationHintParser
implements OptionParser {
    private static final String INIT_BUILD_TIME = "--initialize-at-build-time=";
    private static final String INIT_RUNTIME_TIME = "--initialize-at-run-time=";

    InitializationHintParser() {
    }

    @Override
    public List<Class<? extends Annotation>> getSupportedAnnotations() {
        return List.of(InitializationHint.class, InitializationHints.class);
    }

    @Override
    public List<Option> getOptions(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        Set<TypeElement> elements = HintUtils.getAnnotatedElements(roundEnv, InitializationHint.class, InitializationHints.class);
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<HintOrigin, List> inits = new HashMap<HintOrigin, List>();
        for (TypeElement element : elements) {
            List<Initialization> initializations;
            InitializationHints hints = element.getAnnotation(InitializationHints.class);
            if (hints == null) {
                InitializationHint hint = element.getAnnotation(InitializationHint.class);
                initializations = InitializationHintParser.getAnnotationPhases(element, hint);
            } else {
                initializations = InitializationHintParser.getParentAnnotationPhases(element, InitializationHint.class, InitializationHints.class);
            }
            HintOrigin origin = HintUtils.getHintOrigin(element, processingEnv);
            List value = inits.computeIfAbsent(origin, k -> new ArrayList());
            value.addAll(initializations);
        }
        return inits.entrySet().stream().map(e -> {
            Map<InitializationHint.InitPhase, List<Initialization>> grouped = ((List)e.getValue()).stream().collect(Collectors.groupingBy(i -> i.phase));
            List<String> options = grouped.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().sorted().map(i -> i.className).collect(Collectors.joining(",", this.getInitializationArgumentName((InitializationHint.InitPhase)entry.getKey()), ""))).sorted().collect(Collectors.toList());
            return new Option((HintOrigin)e.getKey(), options);
        }).collect(Collectors.toList());
    }

    private static List<Initialization> getAnnotationPhases(TypeElement element, InitializationHint hint) {
        InitializationHint.InitPhase phase = hint.value();
        List<String> typeNames = Arrays.asList(hint.typeNames());
        List<String> types = HintUtils.getAnnotationFieldClassNames(element, InitializationHint.class, "types");
        if (types.isEmpty() && typeNames.isEmpty()) {
            String selfName = HintUtils.getElementClassName(element);
            return List.of(new Initialization(selfName, phase));
        }
        return Stream.concat(types.stream(), typeNames.stream()).map(t -> new Initialization((String)t, phase)).collect(Collectors.toList());
    }

    private static List<Initialization> getParentAnnotationPhases(TypeElement type, Class<? extends Annotation> annotation, Class<? extends Annotation> parentAnnotation) {
        String annotationName = annotation.getSimpleName();
        String annotationParent = parentAnnotation.getSimpleName();
        return type.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().asElement().getSimpleName().contentEquals(annotationParent)).flatMap(pa -> pa.getElementValues().entrySet().stream()).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().map(AnnotationMirror.class::cast)).filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals(annotationName)).flatMap(a -> {
            List<String> types = HintUtils.getAnnotationFieldValues(a, "types");
            List<String> typeNames = HintUtils.getAnnotationFieldValues(a, "typeNames");
            InitializationHint.InitPhase phase = HintUtils.getAnnotationFieldValues(a, "value").stream().map(InitializationHint.InitPhase::valueOf).findFirst().orElse(InitializationHint.InitPhase.BUILD);
            return types.isEmpty() && typeNames.isEmpty() ? Stream.empty() : Stream.concat(types.stream(), typeNames.stream()).map(t -> new Initialization((String)t, phase));
        }).collect(Collectors.toList());
    }

    private String getInitializationArgumentName(InitializationHint.InitPhase phase) {
        return InitializationHint.InitPhase.BUILD.equals((Object)phase) ? INIT_BUILD_TIME : INIT_RUNTIME_TIME;
    }

    private static class Initialization
    implements Comparable<Initialization> {
        private final String className;
        private final InitializationHint.InitPhase phase;

        Initialization(String className, InitializationHint.InitPhase phase) {
            this.className = className;
            this.phase = phase;
        }

        @Override
        public int compareTo(Initialization o) {
            return this.className.compareTo(o.className);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Initialization that = (Initialization)o;
            return Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }
    }
}

