/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.JniHint;
import io.goodforgod.graalvm.hint.annotation.JniHints;
import io.goodforgod.graalvm.hint.annotation.ReflectionHint;
import io.goodforgod.graalvm.hint.processor.AbstractAccessHintProcessor;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;

public final class JniHintProcessor
extends AbstractAccessHintProcessor {
    private static final Map<String, ReflectionHint.AccessType> ACCESS_TYPE_MAP = Arrays.stream(ReflectionHint.AccessType.values()).collect(Collectors.toMap(Enum::name, e -> e));

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return Set.of(JniHint.class, JniHints.class);
    }

    @Override
    protected String getFileName() {
        return "jni-config.json";
    }

    @Override
    protected List<AbstractAccessHintProcessor.Access> getAccessForElement(TypeElement element) {
        JniHints hints = element.getAnnotation(JniHints.class);
        if (hints == null) {
            JniHint hint = element.getAnnotation(JniHint.class);
            return JniHintProcessor.getAnnotationAccesses(element, hint);
        }
        return JniHintProcessor.getParentAnnotationAccesses(element, JniHint.class, JniHints.class);
    }

    private static List<AbstractAccessHintProcessor.Access> getAnnotationAccesses(TypeElement element, JniHint hint) {
        ReflectionHint.AccessType[] accessTypes = JniHintProcessor.convert(hint.value());
        List<String> typeNames = Arrays.asList(hint.typeNames());
        List<String> types = HintUtils.getAnnotationFieldClassNames(element, JniHint.class, "types");
        if (types.isEmpty() && typeNames.isEmpty()) {
            String selfName = HintUtils.getElementClassName(element);
            return List.of(new AbstractAccessHintProcessor.Access(selfName, accessTypes));
        }
        return Stream.concat(types.stream(), typeNames.stream()).map(t -> new AbstractAccessHintProcessor.Access((String)t, accessTypes)).collect(Collectors.toList());
    }

    private static List<AbstractAccessHintProcessor.Access> getParentAnnotationAccesses(TypeElement type, Class<? extends Annotation> annotation, Class<? extends Annotation> parentAnnotation) {
        String annotationName = annotation.getSimpleName();
        String annotationParent = parentAnnotation.getSimpleName();
        return type.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().asElement().getSimpleName().contentEquals(annotationParent)).flatMap(pa -> pa.getElementValues().entrySet().stream()).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().map(AnnotationMirror.class::cast)).filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals(annotationName)).flatMap(a -> {
            List<String> types = HintUtils.getAnnotationFieldValues(a, "types");
            List<String> typeNames = HintUtils.getAnnotationFieldValues(a, "typeNames");
            ReflectionHint.AccessType[] accessTypes = JniHintProcessor.convert((JniHint.AccessType[])HintUtils.getAnnotationFieldValuesOrDefault(a, "value", List.of(JniHint.AccessType.ALL_DECLARED.name())).stream().map(JniHint.AccessType::valueOf).toArray(JniHint.AccessType[]::new));
            return types.isEmpty() && typeNames.isEmpty() ? Stream.of(new AbstractAccessHintProcessor.Access(HintUtils.getElementClassName(type), accessTypes)) : Stream.concat(types.stream(), typeNames.stream()).map(t -> new AbstractAccessHintProcessor.Access((String)t, accessTypes));
        }).collect(Collectors.toList());
    }

    private static ReflectionHint.AccessType[] convert(JniHint.AccessType[] accessTypes) {
        return (ReflectionHint.AccessType[])Arrays.stream(accessTypes).map(accessType -> ACCESS_TYPE_MAP.get(accessType.name())).toArray(ReflectionHint.AccessType[]::new);
    }
}

