/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.LinkHint;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import io.goodforgod.graalvm.hint.processor.Option;
import io.goodforgod.graalvm.hint.processor.OptionParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

final class LinkHintParser
implements OptionParser {
    private static final String LINK_BUILD_TIME = "--link-at-build-time";

    LinkHintParser() {
    }

    @Override
    public List<Class<? extends Annotation>> getSupportedAnnotations() {
        return List.of(LinkHint.class);
    }

    @Override
    public List<Option> getOptions(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        Set<TypeElement> elements = HintUtils.getAnnotatedElements(roundEnv, LinkHint.class);
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<TypeElement> linkAll = elements.stream().filter(e -> e.getAnnotation(LinkHint.class).all()).findFirst();
        if (linkAll.isPresent()) {
            HintOrigin hintOrigin = HintUtils.getHintOrigin(linkAll.get(), processingEnv);
            return List.of(new Option(hintOrigin, List.of(LINK_BUILD_TIME)));
        }
        HashMap<HintOrigin, List> links = new HashMap<HintOrigin, List>();
        for (TypeElement element : elements) {
            LinkHint hint;
            List hintTypes = this.getTypes(element, hint = element.getAnnotation(LinkHint.class)).collect(Collectors.toList());
            if (hintTypes.isEmpty()) continue;
            HintOrigin origin = HintUtils.getHintOrigin(element, processingEnv);
            List options = links.computeIfAbsent(origin, k -> new ArrayList());
            options.addAll(hintTypes);
        }
        return links.entrySet().stream().map(e -> {
            String linkOption = ((List)e.getValue()).stream().distinct().collect(Collectors.joining(",", "--link-at-build-time=", ""));
            return new Option((HintOrigin)e.getKey(), List.of(linkOption));
        }).collect(Collectors.toList());
    }

    private Stream<String> getTypes(TypeElement element, LinkHint hint) {
        List<String> types = HintUtils.getAnnotationFieldClassNames(element, LinkHint.class, "types");
        List<String> typeNames = Arrays.asList(hint.typeNames());
        if (types.isEmpty() && typeNames.isEmpty()) {
            return Stream.of(HintUtils.getElementClassName(element));
        }
        Stream<String> typeStream = types.stream().map(c -> c.endsWith(".class") ? c.substring(0, c.length() - 6) : c);
        return Stream.concat(typeStream, typeNames.stream());
    }
}

