/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.NativeImageHint;
import io.goodforgod.graalvm.hint.annotation.NativeImageOptions;
import io.goodforgod.graalvm.hint.processor.HintException;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import io.goodforgod.graalvm.hint.processor.Option;
import io.goodforgod.graalvm.hint.processor.OptionParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class NativeImageHintParser
implements OptionParser {
    private static final String ENTRY_POINT_DEFAULT_VALUE = Void.class.getSimpleName();

    NativeImageHintParser() {
    }

    @Override
    public List<Class<? extends Annotation>> getSupportedAnnotations() {
        return List.of(NativeImageHint.class);
    }

    @Override
    public List<Option> getOptions(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        Set<? extends Element> annotatedNative = roundEnv.getElementsAnnotatedWith(NativeImageHint.class);
        Set<TypeElement> elements = ElementFilter.typesIn(annotatedNative);
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        List entrypoints = elements.stream().map(element -> HintUtils.getAnnotationFieldClassNameAny(element, NativeImageHint.class, "entrypoint").filter(name -> !ENTRY_POINT_DEFAULT_VALUE.equals(name)).map(name -> new Entrypoint((String)name, (TypeElement)element, HintUtils.getHintOrigin(element, processingEnv))).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        if (entrypoints.size() > 1) {
            throw new HintException("@NativeImageHint multiple entrypoint detected: " + entrypoints, ((Entrypoint)entrypoints.get((int)1)).source);
        }
        HashMap<HintOrigin, List> options = new HashMap<HintOrigin, List>();
        entrypoints.stream().findFirst().ifPresent(entrypoint -> {
            List<String> entryOptions = this.getEntrypointOptions((Entrypoint)entrypoint);
            options.put(entrypoint.origin, new ArrayList<String>(entryOptions));
        });
        for (TypeElement element2 : elements) {
            NativeImageHint hint = element2.getAnnotation(NativeImageHint.class);
            List hintOptions = Stream.concat(Arrays.stream(hint.options()).map(NativeImageOptions::option), Arrays.stream(hint.optionNames())).distinct().collect(Collectors.toList());
            if (hintOptions.isEmpty()) continue;
            HintOrigin origin = HintUtils.getHintOrigin(element2, processingEnv);
            List resultOptions = options.computeIfAbsent(origin, k -> new ArrayList());
            resultOptions.addAll(hintOptions);
        }
        return options.entrySet().stream().map(e -> new Option((HintOrigin)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
    }

    private List<String> getEntrypointOptions(Entrypoint entrypoint) {
        String appName = entrypoint.hint().name();
        return appName.isBlank() ? List.of("-H:Class=" + entrypoint.className) : List.of("-H:Class=" + entrypoint.className + " -H:Name=" + appName);
    }

    private static class Entrypoint {
        private final String className;
        private final TypeElement source;
        private final HintOrigin origin;

        private Entrypoint(String className, TypeElement source, HintOrigin origin) {
            this.className = className;
            this.source = source;
            this.origin = origin;
        }

        NativeImageHint hint() {
            return this.source.getAnnotation(NativeImageHint.class);
        }

        public String toString() {
            return "entrypoint=" + this.className + ", source=" + this.source.getQualifiedName();
        }
    }
}

