/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.processor.AbstractHintProcessor;
import io.goodforgod.graalvm.hint.processor.DynamicProxyHintParser;
import io.goodforgod.graalvm.hint.processor.HintException;
import io.goodforgod.graalvm.hint.processor.HintFile;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import io.goodforgod.graalvm.hint.processor.InitializationHintParser;
import io.goodforgod.graalvm.hint.processor.LinkHintParser;
import io.goodforgod.graalvm.hint.processor.NativeImageHintParser;
import io.goodforgod.graalvm.hint.processor.Option;
import io.goodforgod.graalvm.hint.processor.OptionParser;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public final class NativeImageHintProcessor
extends AbstractHintProcessor {
    private static final String FILE_NAME = "native-image.properties";
    private static final String ARG_SEPARATOR = " \\\n       ";
    private static final List<OptionParser> OPTION_PARSERS = List.of(new NativeImageHintParser(), new InitializationHintParser(), new LinkHintParser(), new DynamicProxyHintParser());

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return OPTION_PARSERS.stream().flatMap(p -> p.getSupportedAnnotations().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotatedElements, RoundEnvironment roundEnv) {
        if (annotatedElements.isEmpty()) {
            return false;
        }
        try {
            List options = OPTION_PARSERS.stream().flatMap(parser -> parser.getOptions(roundEnv, this.processingEnv).stream()).collect(Collectors.groupingBy(Option::getOrigin)).entrySet().stream().map(e -> {
                List<String> mergedOptions = ((List)e.getValue()).stream().flatMap(v -> v.getOptions().stream()).distinct().collect(Collectors.toList());
                return new Option((HintOrigin)e.getKey(), mergedOptions);
            }).collect(Collectors.toList());
            if (options.isEmpty()) {
                String annotations = OPTION_PARSERS.stream().flatMap(parser -> parser.getSupportedAnnotations().stream().filter(a -> !roundEnv.getElementsAnnotatedWith((Class<? extends Annotation>)a).isEmpty())).map(Class::getSimpleName).collect(Collectors.joining(","));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotations + " are present but no options retrieved");
                return false;
            }
            for (Option option : options) {
                String nativeImageProperties = option.getOptions().stream().collect(Collectors.joining(ARG_SEPARATOR, "Args = ", ""));
                HintFile file = option.getOrigin().getFileWithRelativePath(FILE_NAME);
                if (HintUtils.writeConfigFile(file, nativeImageProperties, this.processingEnv)) continue;
                return false;
            }
            return true;
        }
        catch (HintException e2) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e2.getMessage(), e2.getElement());
            return false;
        }
        catch (Exception e3) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, e3.getMessage());
            e3.printStackTrace();
            return false;
        }
    }
}

