/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.ReflectionHint;
import io.goodforgod.graalvm.hint.annotation.ReflectionHints;
import io.goodforgod.graalvm.hint.processor.AbstractAccessHintProcessor;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;

public final class ReflectionHintProcessor
extends AbstractAccessHintProcessor {
    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return Set.of(ReflectionHint.class, ReflectionHints.class);
    }

    @Override
    protected String getFileName() {
        return "reflect-config.json";
    }

    @Override
    protected List<AbstractAccessHintProcessor.Access> getAccessForElement(TypeElement element) {
        ReflectionHints hints = element.getAnnotation(ReflectionHints.class);
        if (hints == null) {
            ReflectionHint hint = element.getAnnotation(ReflectionHint.class);
            return ReflectionHintProcessor.getAnnotationAccesses(element, hint);
        }
        return ReflectionHintProcessor.getParentAnnotationAccesses(element, ReflectionHint.class, ReflectionHints.class);
    }

    private static List<AbstractAccessHintProcessor.Access> getAnnotationAccesses(TypeElement element, ReflectionHint hint) {
        ReflectionHint.AccessType[] accessTypes = hint.value();
        List<String> typeNames = Arrays.asList(hint.typeNames());
        List<String> types = HintUtils.getAnnotationFieldClassNames(element, ReflectionHint.class, "types");
        if (types.isEmpty() && typeNames.isEmpty()) {
            String selfName = HintUtils.getElementClassName(element);
            return List.of(new AbstractAccessHintProcessor.Access(selfName, accessTypes));
        }
        return Stream.concat(types.stream(), typeNames.stream()).map(t -> new AbstractAccessHintProcessor.Access((String)t, accessTypes)).collect(Collectors.toList());
    }

    private static List<AbstractAccessHintProcessor.Access> getParentAnnotationAccesses(TypeElement type, Class<? extends Annotation> annotation, Class<? extends Annotation> parentAnnotation) {
        String annotationName = annotation.getSimpleName();
        String annotationParent = parentAnnotation.getSimpleName();
        return type.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().asElement().getSimpleName().contentEquals(annotationParent)).flatMap(pa -> pa.getElementValues().entrySet().stream()).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().map(AnnotationMirror.class::cast)).filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals(annotationName)).flatMap(a -> {
            List<String> types = HintUtils.getAnnotationFieldValues(a, "types");
            List<String> typeNames = HintUtils.getAnnotationFieldValues(a, "typeNames");
            ReflectionHint.AccessType[] accessTypes = (ReflectionHint.AccessType[])HintUtils.getAnnotationFieldValuesOrDefault(a, "value", List.of(ReflectionHint.AccessType.ALL_DECLARED.name())).stream().map(ReflectionHint.AccessType::valueOf).toArray(ReflectionHint.AccessType[]::new);
            return types.isEmpty() && typeNames.isEmpty() ? Stream.of(new AbstractAccessHintProcessor.Access(HintUtils.getElementClassName(type), accessTypes)) : Stream.concat(types.stream(), typeNames.stream()).map(t -> new AbstractAccessHintProcessor.Access((String)t, accessTypes));
        }).collect(Collectors.toList());
    }
}

