/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.graalvm.hint.processor;

import io.goodforgod.graalvm.hint.annotation.ResourceHint;
import io.goodforgod.graalvm.hint.processor.AbstractHintProcessor;
import io.goodforgod.graalvm.hint.processor.HintException;
import io.goodforgod.graalvm.hint.processor.HintFile;
import io.goodforgod.graalvm.hint.processor.HintOrigin;
import io.goodforgod.graalvm.hint.processor.HintUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public final class ResourceHintProcessor
extends AbstractHintProcessor {
    private static final String FILE_NAME = "resource-config.json";

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return Set.of(ResourceHint.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        try {
            Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(ResourceHint.class);
            Set<TypeElement> elements = ElementFilter.typesIn(annotated);
            HashMap<HintOrigin, Resources> resourcesMap = new HashMap<HintOrigin, Resources>();
            for (TypeElement typeElement : elements) {
                HintOrigin origin = HintUtils.getHintOrigin(typeElement, this.processingEnv);
                Resources resources = resourcesMap.computeIfAbsent(origin, k -> new Resources());
                Resources resourceForElement = ResourceHintProcessor.getResource(typeElement);
                resources.includes.addAll(resourceForElement.includes);
                resources.excludes.addAll(resourceForElement.excludes);
                resources.bundles.addAll(resourceForElement.bundles);
            }
            for (Map.Entry entry : resourcesMap.entrySet()) {
                String resourceConfigJson = ResourceHintProcessor.getResourceConfig((Resources)entry.getValue());
                HintFile file = ((HintOrigin)entry.getKey()).getFileWithRelativePath(FILE_NAME);
                if (HintUtils.writeConfigFile(file, resourceConfigJson, this.processingEnv)) continue;
                return false;
            }
            return true;
        }
        catch (HintException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
            return false;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static String getResourceConfig(Resources resources) {
        StringBuilder configBuilder = new StringBuilder();
        configBuilder.append("{");
        if (resources.haveIncludes() || resources.haveExcludes()) {
            configBuilder.append("\n  \"resources\": {\n");
            if (resources.haveIncludes()) {
                String includePart = ResourceHintProcessor.getResourceConfigPart("includes", resources.includes);
                configBuilder.append(includePart);
            }
            if (resources.haveExcludes()) {
                if (resources.haveIncludes()) {
                    configBuilder.append(",\n");
                }
                String excludePart = ResourceHintProcessor.getResourceConfigPart("excludes", resources.excludes);
                configBuilder.append(excludePart);
            }
            if (resources.haveBundles()) {
                configBuilder.append("\n  },");
            } else {
                configBuilder.append("\n  }");
            }
        }
        if (resources.haveBundles()) {
            configBuilder.append("\n");
            String bundlePart = ResourceHintProcessor.getBundleConfigPart(resources.bundles);
            configBuilder.append(bundlePart);
        }
        configBuilder.append("\n}");
        return configBuilder.toString();
    }

    private static String getResourceConfigPart(String partName, Collection<String> resources) {
        return resources.stream().sorted().map(resource -> String.format("      { \"%s\": \"%s\" }", "pattern", resource)).collect(Collectors.joining(",\n", "    \"" + partName + "\": [\n", "\n    ]"));
    }

    private static String getBundleConfigPart(Collection<String> bundles) {
        return bundles.stream().sorted().map(bundle -> String.format("    { \"%s\": \"%s\" }", "name", bundle)).collect(Collectors.joining(",\n", "  \"bundles\": [\n", "\n  ]"));
    }

    private static Resources getResource(TypeElement element) {
        Resources resources = new Resources();
        ResourceHint annotation = element.getAnnotation(ResourceHint.class);
        List<String> includeBatch = ResourceHintProcessor.filterValues(annotation.include());
        List<String> excludeBatch = ResourceHintProcessor.filterValues(annotation.exclude());
        List<String> bundleBatch = ResourceHintProcessor.filterValues(annotation.bundles());
        if (includeBatch.isEmpty() && excludeBatch.isEmpty() && bundleBatch.isEmpty()) {
            throw new HintException(element.getQualifiedName().toString() + " is annotated with @" + ResourceHint.class.getSimpleName() + ", but no valid 'include' or 'exclude' or 'bundle' parameters specified!", element);
        }
        resources.includes.addAll(includeBatch);
        resources.excludes.addAll(excludeBatch);
        resources.bundles.addAll(bundleBatch);
        return resources;
    }

    private static List<String> filterValues(String[] stringValues) {
        return Arrays.stream(stringValues).filter(a -> !a.isBlank()).collect(Collectors.toList());
    }

    private static class Resources {
        private final Set<String> includes = new LinkedHashSet<String>();
        private final Set<String> excludes = new LinkedHashSet<String>();
        private final Set<String> bundles = new LinkedHashSet<String>();

        private Resources() {
        }

        boolean haveIncludes() {
            return !this.includes.isEmpty();
        }

        boolean haveExcludes() {
            return !this.excludes.isEmpty();
        }

        boolean haveBundles() {
            return !this.bundles.isEmpty();
        }
    }
}

