/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.Internal;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Internal
public abstract class Bootstrapper {
    private static final String LOG_PREFIX = "xds-bootstrap";
    private static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    @VisibleForTesting
    static final String CLIENT_FEATURE_DISABLE_OVERPROVISIONING = "envoy.lb.does_not_support_overprovisioning";
    private static final Bootstrapper DEFAULT_INSTANCE = new Bootstrapper(){

        @Override
        public BootstrapInfo readBootstrap() throws IOException {
            String filePath = System.getenv(Bootstrapper.BOOTSTRAP_PATH_SYS_ENV_VAR);
            if (filePath == null) {
                throw new IOException("Environment variable GRPC_XDS_BOOTSTRAP not defined.");
            }
            XdsLogger.withPrefix(Bootstrapper.LOG_PREFIX).log(XdsLogger.XdsLogLevel.INFO, "GRPC_XDS_BOOTSTRAP={0}", filePath);
            return 1.parseConfig(new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8));
        }
    };

    public static Bootstrapper getInstance() {
        return DEFAULT_INSTANCE;
    }

    public abstract BootstrapInfo readBootstrap() throws IOException;

    @VisibleForTesting
    static BootstrapInfo parseConfig(String rawData) throws IOException {
        XdsLogger logger = XdsLogger.withPrefix(LOG_PREFIX);
        logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap information");
        Map rawBootstrap = (Map)JsonParser.parse((String)rawData);
        logger.log(XdsLogger.XdsLogLevel.DEBUG, "Bootstrap configuration:\n{0}", rawBootstrap);
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        List rawServerConfigs = JsonUtil.getList((Map)rawBootstrap, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new IOException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS servers", rawServerConfigs.size());
        List serverConfigList = JsonUtil.checkObjectList((List)rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new IOException("Invalid bootstrap: 'xds_servers' contains unknown server.");
            }
            logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server URI: {0}", serverUri);
            ArrayList<ChannelCreds> channelCredsOptions = new ArrayList<ChannelCreds>();
            List rawChannelCredsList = JsonUtil.getList((Map)serverConfig, (String)"channel_creds");
            if (rawChannelCredsList != null) {
                List channelCredsList = JsonUtil.checkObjectList((List)rawChannelCredsList);
                for (Map channelCreds : channelCredsList) {
                    String type = JsonUtil.getString((Map)channelCreds, (String)"type");
                    if (type == null) {
                        throw new IOException("Invalid bootstrap: 'xds_servers' contains server with unknown type 'channel_creds'.");
                    }
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Channel credentials option: {0}", type);
                    ChannelCreds creds = new ChannelCreds(type, JsonUtil.getObject((Map)channelCreds, (String)"config"));
                    channelCredsOptions.add(creds);
                }
            }
            servers.add(new ServerInfo(serverUri, channelCredsOptions));
        }
        Node.Builder nodeBuilder = Node.newBuilder();
        Map rawNode = JsonUtil.getObject((Map)rawBootstrap, (String)"node");
        if (rawNode != null) {
            Map rawLocality;
            Map metadata;
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Node id: {0}", id);
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Node cluster: {0}", cluster);
                nodeBuilder.setCluster(cluster);
            }
            if ((metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata")) != null) {
                Struct.Builder structBuilder = Struct.newBuilder();
                for (Map.Entry entry : metadata.entrySet()) {
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Node metadata field {0}: {1}", entry.getKey(), entry.getValue());
                    structBuilder.putFields((String)entry.getKey(), Bootstrapper.convertToValue(entry.getValue()));
                }
                nodeBuilder.setMetadata(structBuilder);
            }
            if ((rawLocality = JsonUtil.getObject((Map)rawNode, (String)"locality")) != null) {
                Locality.Builder localityBuilder = Locality.newBuilder();
                if (rawLocality.containsKey("region")) {
                    String region = JsonUtil.getString((Map)rawLocality, (String)"region");
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality region: {0}", region);
                    localityBuilder.setRegion(region);
                }
                if (rawLocality.containsKey("zone")) {
                    String zone = JsonUtil.getString((Map)rawLocality, (String)"zone");
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality zone: {0}", zone);
                    localityBuilder.setZone(zone);
                }
                if (rawLocality.containsKey("sub_zone")) {
                    String subZone = JsonUtil.getString((Map)rawLocality, (String)"sub_zone");
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality sub_zone: {0}", subZone);
                    localityBuilder.setSubZone(subZone);
                }
                nodeBuilder.setLocality(localityBuilder);
            }
        }
        GrpcUtil.GrpcBuildVersion buildVersion = GrpcUtil.getGrpcBuildVersion();
        logger.log(XdsLogger.XdsLogLevel.INFO, "Build version: {0}", buildVersion);
        nodeBuilder.setBuildVersion(buildVersion.toString());
        nodeBuilder.setUserAgentName(buildVersion.getUserAgent());
        nodeBuilder.setUserAgentVersion(buildVersion.getImplementationVersion());
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_DISABLE_OVERPROVISIONING);
        return new BootstrapInfo(servers, nodeBuilder.build());
    }

    private static Value convertToValue(Object rawObject) {
        Value.Builder valueBuilder = Value.newBuilder();
        if (rawObject == null) {
            valueBuilder.setNullValue(NullValue.NULL_VALUE);
        } else if (rawObject instanceof Double) {
            valueBuilder.setNumberValue(((Double)rawObject).doubleValue());
        } else if (rawObject instanceof String) {
            valueBuilder.setStringValue((String)rawObject);
        } else if (rawObject instanceof Boolean) {
            valueBuilder.setBoolValue(((Boolean)rawObject).booleanValue());
        } else if (rawObject instanceof Map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            Map map = (Map)rawObject;
            for (Map.Entry entry : map.entrySet()) {
                structBuilder.putFields((String)entry.getKey(), Bootstrapper.convertToValue(entry.getValue()));
            }
            valueBuilder.setStructValue(structBuilder);
        } else if (rawObject instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            List list = (List)rawObject;
            for (Object obj : list) {
                listBuilder.addValues(Bootstrapper.convertToValue(obj));
            }
            valueBuilder.setListValue(listBuilder);
        }
        return valueBuilder.build();
    }

    @Internal
    @Immutable
    public static class BootstrapInfo {
        private List<ServerInfo> servers;
        private final Node node;

        @VisibleForTesting
        BootstrapInfo(List<ServerInfo> servers, Node node) {
            this.servers = servers;
            this.node = node;
        }

        List<ServerInfo> getServers() {
            return Collections.unmodifiableList(this.servers);
        }

        public Node getNode() {
            return this.node;
        }
    }

    @Immutable
    static class ServerInfo {
        private final String serverUri;
        private final List<ChannelCreds> channelCredsList;

        @VisibleForTesting
        ServerInfo(String serverUri, List<ChannelCreds> channelCredsList) {
            this.serverUri = serverUri;
            this.channelCredsList = channelCredsList;
        }

        String getServerUri() {
            return this.serverUri;
        }

        List<ChannelCreds> getChannelCredentials() {
            return Collections.unmodifiableList(this.channelCredsList);
        }
    }

    @Immutable
    static class ChannelCreds {
        private final String type;
        @Nullable
        private final Map<String, ?> config;

        @VisibleForTesting
        ChannelCreds(String type, @Nullable Map<String, ?> config) {
            this.type = type;
            this.config = config;
        }

        String getType() {
            return this.type;
        }

        @Nullable
        Map<String, ?> getConfig() {
            if (this.config != null) {
                return Collections.unmodifiableMap(this.config);
            }
            return null;
        }
    }
}

