/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.xds.EdsLoadBalancer;
import io.grpc.xds.FallbackLb;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

final class XdsLoadBalancer
extends LoadBalancer {
    private static final long FALLBACK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private final LoadBalancer.Helper helper;
    private final LoadBalancer primaryLb;
    private final LoadBalancer.Factory fallbackLbFactory;
    private final EdsLoadBalancer.ResourceUpdateCallback resourceUpdateCallback = new EdsLoadBalancer.ResourceUpdateCallback(){

        @Override
        public void onWorking() {
            if (XdsLoadBalancer.this.primaryPolicyHasBeenReady) {
                XdsLoadBalancer.this.cancelFallbackTimer();
            }
            XdsLoadBalancer.this.primaryPolicyWorked = true;
        }

        @Override
        public void onError() {
            if (!XdsLoadBalancer.this.primaryPolicyWorked) {
                XdsLoadBalancer.this.useFallbackPolicy();
            } else if (XdsLoadBalancer.this.primaryPolicyHasBeenReady) {
                // empty if block
            }
        }

        @Override
        public void onAllDrop() {
            XdsLoadBalancer.this.cancelFallback();
        }
    };
    @Nullable
    private LoadBalancer fallbackLb;
    @Nullable
    private LoadBalancer.ResolvedAddresses resolvedAddresses;
    @CheckForNull
    private SynchronizationContext.ScheduledHandle fallbackTimer;
    private boolean primaryPolicyWorked;
    private boolean primaryPolicyHasBeenReady;

    XdsLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, new EdsLoadBalancerFactory(), new FallbackLbFactory());
    }

    @VisibleForTesting
    XdsLoadBalancer(LoadBalancer.Helper helper, PrimaryLbFactory primaryLbFactory, LoadBalancer.Factory fallbackLbFactory) {
        this.helper = helper;
        this.primaryLb = primaryLbFactory.newLoadBalancer((LoadBalancer.Helper)new PrimaryLbHelper(), this.resourceUpdateCallback);
        this.fallbackLbFactory = fallbackLbFactory;
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.resolvedAddresses = resolvedAddresses;
        if (this.isInFallbackMode()) {
            this.fallbackLb.handleResolvedAddresses(this.resolvedAddresses);
        }
        if (this.fallbackTimer == null) {
            class EnterFallbackTask
            implements Runnable {
                EnterFallbackTask() {
                }

                @Override
                public void run() {
                    XdsLoadBalancer.this.useFallbackPolicy();
                }
            }
            this.fallbackTimer = this.helper.getSynchronizationContext().schedule((Runnable)new EnterFallbackTask(), FALLBACK_TIMEOUT_MS, TimeUnit.MILLISECONDS, this.helper.getScheduledExecutorService());
        }
        this.primaryLb.handleResolvedAddresses(resolvedAddresses);
    }

    public void handleNameResolutionError(Status error) {
        this.primaryLb.handleNameResolutionError(error);
        if (this.isInFallbackMode()) {
            this.fallbackLb.handleNameResolutionError(error);
        }
    }

    public void requestConnection() {
        this.primaryLb.requestConnection();
        if (this.isInFallbackMode()) {
            this.fallbackLb.requestConnection();
        }
    }

    public void shutdown() {
        this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Shutting down XDS balancer");
        this.primaryLb.shutdown();
        this.cancelFallback();
    }

    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        throw new UnsupportedOperationException("handleSubchannelState() not supported by XdsLoadBalancer");
    }

    private void cancelFallbackTimer() {
        if (this.fallbackTimer != null) {
            this.fallbackTimer.cancel();
        }
    }

    private void cancelFallback() {
        this.cancelFallbackTimer();
        if (this.isInFallbackMode()) {
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Shutting down XDS fallback balancer");
            this.fallbackLb.shutdown();
            this.fallbackLb = null;
        }
    }

    private void useFallbackPolicy() {
        if (this.isInFallbackMode()) {
            return;
        }
        this.cancelFallbackTimer();
        this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Using XDS fallback policy");
        FallbackLbHelper fallbackLbHelper = new FallbackLbHelper();
        fallbackLbHelper.balancer = this.fallbackLb = this.fallbackLbFactory.newLoadBalancer((LoadBalancer.Helper)fallbackLbHelper);
        this.fallbackLb.handleResolvedAddresses(this.resolvedAddresses);
    }

    private boolean isInFallbackMode() {
        return this.fallbackLb != null;
    }

    private static final class FallbackLbFactory
    extends LoadBalancer.Factory {
        private FallbackLbFactory() {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new FallbackLb(helper);
        }
    }

    private static final class EdsLoadBalancerFactory
    implements PrimaryLbFactory {
        private EdsLoadBalancerFactory() {
        }

        @Override
        public LoadBalancer newLoadBalancer(LoadBalancer.Helper edsLbHelper, EdsLoadBalancer.ResourceUpdateCallback resourceUpdateCallback) {
            return new EdsLoadBalancer(edsLbHelper, resourceUpdateCallback);
        }
    }

    @VisibleForTesting
    static interface PrimaryLbFactory {
        public LoadBalancer newLoadBalancer(LoadBalancer.Helper var1, EdsLoadBalancer.ResourceUpdateCallback var2);
    }

    private final class FallbackLbHelper
    extends ForwardingLoadBalancerHelper {
        LoadBalancer balancer;

        private FallbackLbHelper() {
        }

        protected LoadBalancer.Helper delegate() {
            return XdsLoadBalancer.this.helper;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            Preconditions.checkNotNull((Object)this.balancer, (Object)"balancer not set yet");
            if (this.balancer != XdsLoadBalancer.this.fallbackLb) {
                return;
            }
            XdsLoadBalancer.this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Picker updated - state: {0}, picker: {1}", new Object[]{newState, newPicker});
            super.updateBalancingState(newState, newPicker);
        }
    }

    private final class PrimaryLbHelper
    extends ForwardingLoadBalancerHelper {
        private PrimaryLbHelper() {
        }

        protected LoadBalancer.Helper delegate() {
            return XdsLoadBalancer.this.helper;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            if (newState == ConnectivityState.READY) {
                Preconditions.checkState((boolean)XdsLoadBalancer.this.primaryPolicyWorked, (Object)"channel goes to READY before the load balancer even worked");
                XdsLoadBalancer.this.primaryPolicyHasBeenReady = true;
                XdsLoadBalancer.this.cancelFallback();
            }
            if (!XdsLoadBalancer.this.isInFallbackMode()) {
                XdsLoadBalancer.this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Picker updated - state: {0}, picker: {1}", new Object[]{newState, newPicker});
                XdsLoadBalancer.this.helper.updateBalancingState(newState, newPicker);
            }
        }
    }
}

