/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingSslContextProviderMap;
import io.grpc.xds.internal.sds.SdsSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.io.IOException;
import java.util.concurrent.Executors;

final class ClientSslContextProviderFactory
implements ReferenceCountingSslContextProviderMap.SslContextProviderFactory<UpstreamTlsContext> {
    ClientSslContextProviderFactory() {
    }

    @Override
    public SslContextProvider<UpstreamTlsContext> createSslContextProvider(UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        Preconditions.checkArgument((boolean)upstreamTlsContext.hasCommonTlsContext(), (Object)"upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(upstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeSslContextProvider.getProviderForClient(upstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(upstreamTlsContext.getCommonTlsContext())) {
            try {
                return SdsSslContextProvider.getProviderForClient(upstreamTlsContext, Bootstrapper.getInstance().readBootstrap().getNode(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("client-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new UnsupportedOperationException("UpstreamTlsContext to have all filenames or all SdsConfig");
    }
}

