/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ReferenceCountingSslContextProviderMap<K> {
    private final Map<K, Instance<K>> instances = new HashMap<K, Instance<K>>();
    private final SslContextProviderFactory<K> sslContextProviderFactory;

    ReferenceCountingSslContextProviderMap(SslContextProviderFactory<K> sslContextProviderFactory) {
        Preconditions.checkNotNull(sslContextProviderFactory, (Object)"sslContextProviderFactory");
        this.sslContextProviderFactory = sslContextProviderFactory;
    }

    @CheckReturnValue
    public SslContextProvider<K> get(K key) {
        Preconditions.checkNotNull(key, (Object)"key");
        return this.getInternal(key);
    }

    public SslContextProvider<K> release(SslContextProvider<K> value) {
        Preconditions.checkNotNull(value, (Object)"value");
        K key = value.getSource();
        return this.releaseInternal(key, value);
    }

    private synchronized SslContextProvider<K> getInternal(K key) {
        Instance<K> instance = this.instances.get(key);
        if (instance == null) {
            instance = new Instance<K>(this.sslContextProviderFactory.createSslContextProvider(key));
            this.instances.put(key, instance);
            return instance.sslContextProvider;
        }
        return instance.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SslContextProvider<K> releaseInternal(K key, SslContextProvider<K> instance) {
        Instance<K> cached = this.instances.get(key);
        Preconditions.checkArgument((cached != null ? 1 : 0) != 0, (String)"No cached instance found for %s", key);
        Preconditions.checkArgument((instance == cached.sslContextProvider ? 1 : 0) != 0, (Object)"Releasing the wrong instance");
        if (cached.release()) {
            try {
                cached.sslContextProvider.close();
            }
            finally {
                this.instances.remove(key);
            }
        }
        return null;
    }

    private static class Instance<K> {
        final SslContextProvider<K> sslContextProvider;
        private int refCount;

        SslContextProvider<K> acquire() {
            ++this.refCount;
            return this.sslContextProvider;
        }

        boolean release() {
            Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0, (Object)"refCount has to be > 0");
            return --this.refCount == 0;
        }

        Instance(SslContextProvider<K> sslContextProvider) {
            this.sslContextProvider = sslContextProvider;
            this.refCount = 1;
        }
    }

    public static interface SslContextProviderFactory<K> {
        public SslContextProvider<K> createSslContextProvider(K var1);
    }
}

