/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.SynchronizationContext;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@VisibleForTesting
public final class SdsProtocolNegotiators {
    private static final Logger logger = Logger.getLogger(SdsProtocolNegotiators.class.getName());
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"https");

    public static InternalNettyChannelBuilder.ProtocolNegotiatorFactory clientProtocolNegotiatorFactory(@Nullable UpstreamTlsContext upstreamTlsContext) {
        return new ClientSdsProtocolNegotiatorFactory(upstreamTlsContext);
    }

    public static InternalProtocolNegotiator.ProtocolNegotiator serverProtocolNegotiator(@Nullable DownstreamTlsContext downstreamTlsContext, int port, SynchronizationContext syncContext) {
        XdsClientWrapperForServerSds xdsClientWrapperForServerSds = ServerSdsProtocolNegotiator.getXdsClientWrapperForServerSds(port, syncContext);
        if (xdsClientWrapperForServerSds == null && downstreamTlsContext == null) {
            logger.log(Level.INFO, "Fallback to plaintext for server at port {0}", port);
            return InternalProtocolNegotiators.serverPlaintext();
        }
        return new ServerSdsProtocolNegotiator(downstreamTlsContext, xdsClientWrapperForServerSds);
    }

    @VisibleForTesting
    static final class ServerSdsHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final DownstreamTlsContext downstreamTlsContext;

        ServerSdsHandler(GrpcHttp2ConnectionHandler grpcHandler, DownstreamTlsContext downstreamTlsContext) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            });
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.downstreamTlsContext = downstreamTlsContext;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            final SslContextProvider<DownstreamTlsContext> sslContextProvider = TlsContextManagerImpl.getInstance().findOrCreateServerSslContextProvider(this.downstreamTlsContext);
            sslContextProvider.addCallback(new SslContextProvider.Callback(){

                @Override
                public void updateSecret(SslContext sslContext) {
                    ChannelHandler handler = InternalProtocolNegotiators.serverTls((SslContext)sslContext).newHandler(ServerSdsHandler.this.grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    ServerSdsHandler.this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                    TlsContextManagerImpl.getInstance().releaseServerSslContextProvider(sslContextProvider);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            }, (Executor)ctx.executor());
        }
    }

    @VisibleForTesting
    static final class HandlerPickerHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final DownstreamTlsContext downstreamTlsContextFromBuilder;
        private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;

        HandlerPickerHandler(GrpcHttp2ConnectionHandler grpcHandler, @Nullable DownstreamTlsContext downstreamTlsContext, @Nullable XdsClientWrapperForServerSds xdsClientWrapperForServerSds) {
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.downstreamTlsContextFromBuilder = downstreamTlsContext;
            this.xdsClientWrapperForServerSds = xdsClientWrapperForServerSds;
        }

        private static boolean isTlsContextEmpty(DownstreamTlsContext downstreamTlsContext) {
            return downstreamTlsContext == null || !downstreamTlsContext.hasCommonTlsContext();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                DownstreamTlsContext downstreamTlsContext;
                DownstreamTlsContext downstreamTlsContext2 = downstreamTlsContext = this.xdsClientWrapperForServerSds == null ? null : this.xdsClientWrapperForServerSds.getDownstreamTlsContext(ctx.channel());
                if (HandlerPickerHandler.isTlsContextEmpty(downstreamTlsContext)) {
                    downstreamTlsContext = this.downstreamTlsContextFromBuilder;
                }
                if (HandlerPickerHandler.isTlsContextEmpty(downstreamTlsContext)) {
                    logger.log(Level.INFO, "Fallback to plaintext for {0}", ctx.channel().localAddress());
                    ctx.pipeline().replace((ChannelHandler)this, null, InternalProtocolNegotiators.serverPlaintext().newHandler(this.grpcHandler));
                    ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();
                    ctx.fireUserEventTriggered((Object)pne);
                    return;
                }
                ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)new ServerSdsHandler(this.grpcHandler, downstreamTlsContext));
                ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();
                ctx.fireUserEventTriggered((Object)pne);
                return;
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    @VisibleForTesting
    public static final class ServerSdsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        @Nullable
        private final DownstreamTlsContext downstreamTlsContext;
        @Nullable
        private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;

        @VisibleForTesting
        public ServerSdsProtocolNegotiator(@Nullable DownstreamTlsContext downstreamTlsContext, @Nullable XdsClientWrapperForServerSds xdsClientWrapperForServerSds) {
            Preconditions.checkArgument((downstreamTlsContext != null || xdsClientWrapperForServerSds != null ? 1 : 0) != 0, (Object)"both downstreamTlsContext and xdsClientWrapperForServerSds cannot be null");
            this.downstreamTlsContext = downstreamTlsContext;
            this.xdsClientWrapperForServerSds = xdsClientWrapperForServerSds;
        }

        private static XdsClientWrapperForServerSds getXdsClientWrapperForServerSds(int port, SynchronizationContext syncContext) {
            try {
                return XdsClientWrapperForServerSds.newInstance(port, Bootstrapper.getInstance(), syncContext);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Fallback to plaintext due to exception", e);
                return null;
            }
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new HandlerPickerHandler(grpcHandler, this.downstreamTlsContext, this.xdsClientWrapperForServerSds);
        }

        public void close() {
            if (this.xdsClientWrapperForServerSds != null) {
                this.xdsClientWrapperForServerSds.shutdown();
            }
        }
    }

    @VisibleForTesting
    static final class ClientSdsHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final UpstreamTlsContext upstreamTlsContext;

        ClientSdsHandler(GrpcHttp2ConnectionHandler grpcHandler, UpstreamTlsContext upstreamTlsContext) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            });
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.upstreamTlsContext = upstreamTlsContext;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            final SslContextProvider<UpstreamTlsContext> sslContextProvider = TlsContextManagerImpl.getInstance().findOrCreateClientSslContextProvider(this.upstreamTlsContext);
            sslContextProvider.addCallback(new SslContextProvider.Callback(){

                @Override
                public void updateSecret(SslContext sslContext) {
                    logger.log(Level.FINEST, "ClientSdsHandler.updateSecret authority={0}, ctx.name={1}", new Object[]{ClientSdsHandler.this.grpcHandler.getAuthority(), ctx.name()});
                    ChannelHandler handler = InternalProtocolNegotiators.tls((SslContext)sslContext).newHandler(ClientSdsHandler.this.grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    ClientSdsHandler.this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                    TlsContextManagerImpl.getInstance().releaseClientSslContextProvider(sslContextProvider);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            }, (Executor)ctx.executor());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    private static class BufferReadsHandler
    extends ChannelInboundHandlerAdapter {
        private final List<Object> reads = new ArrayList<Object>();
        private boolean readComplete;

        private BufferReadsHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.reads.add(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.readComplete = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            for (Object msg : this.reads) {
                super.channelRead(ctx, msg);
            }
            if (this.readComplete) {
                super.channelReadComplete(ctx);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    @VisibleForTesting
    static final class ClientSdsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        UpstreamTlsContext upstreamTlsContext;

        ClientSdsProtocolNegotiator(UpstreamTlsContext upstreamTlsContext) {
            this.upstreamTlsContext = upstreamTlsContext;
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            UpstreamTlsContext localUpstreamTlsContext = (UpstreamTlsContext)grpcHandler.getEagAttributes().get(XdsAttributes.ATTR_UPSTREAM_TLS_CONTEXT);
            if (localUpstreamTlsContext == null) {
                localUpstreamTlsContext = this.upstreamTlsContext;
            }
            if (ClientSdsProtocolNegotiator.isTlsContextEmpty(localUpstreamTlsContext)) {
                return InternalProtocolNegotiators.plaintext().newHandler(grpcHandler);
            }
            return new ClientSdsHandler(grpcHandler, localUpstreamTlsContext);
        }

        private static boolean isTlsContextEmpty(UpstreamTlsContext upstreamTlsContext) {
            return upstreamTlsContext == null || !upstreamTlsContext.hasCommonTlsContext();
        }

        public void close() {
        }
    }

    private static final class ClientSdsProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private final UpstreamTlsContext upstreamTlsContext;

        ClientSdsProtocolNegotiatorFactory(UpstreamTlsContext upstreamTlsContext) {
            this.upstreamTlsContext = upstreamTlsContext;
        }

        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            final ClientSdsProtocolNegotiator negotiator = new ClientSdsProtocolNegotiator(this.upstreamTlsContext);
            final class LocalSdsNegotiator
            implements InternalProtocolNegotiator.ProtocolNegotiator {
                LocalSdsNegotiator() {
                }

                public AsciiString scheme() {
                    return negotiator.scheme();
                }

                public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                    return negotiator.newHandler(grpcHandler);
                }

                public void close() {
                    negotiator.close();
                }
            }
            return new LocalSdsNegotiator();
        }
    }
}

