/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.ActivationLogEntryBlueprint;
import io.helidon.inject.api.ActivationResult;
import io.helidon.inject.api.Event;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.ServiceProvider;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ActivationLogEntryBlueprint")
public interface ActivationLogEntry
extends ActivationLogEntryBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ActivationLogEntry instance) {
        return (Builder)ActivationLogEntry.builder().from(instance);
    }

    public static ActivationLogEntry create() {
        return ActivationLogEntry.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ActivationLogEntry>
    implements io.helidon.common.Builder<Builder, ActivationLogEntry> {
        private Builder() {
        }

        public ActivationLogEntry buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ActivationLogEntryImpl(this);
        }

        public ActivationLogEntry build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationLogEntry>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private ActivationResult activationResult;
        private Event event;
        private InjectionPointInfo injectionPoint;
        private Instant time;
        private long threadId = 0L;
        private ServiceProvider<?> serviceProvider;
        private String message;
        private Throwable error;

        protected BuilderBase() {
        }

        public BUILDER from(ActivationLogEntry prototype) {
            this.event(prototype.event());
            this.message(prototype.message());
            this.activationResult(prototype.activationResult());
            this.serviceProvider(prototype.serviceProvider());
            this.injectionPoint(prototype.injectionPoint());
            this.time(prototype.time());
            this.error(prototype.error());
            this.threadId(prototype.threadId());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.event().ifPresent(this::event);
            builder.message().ifPresent(this::message);
            builder.activationResult().ifPresent(this::activationResult);
            builder.serviceProvider().ifPresent(this::serviceProvider);
            builder.injectionPoint().ifPresent(this::injectionPoint);
            builder.time().ifPresent(this::time);
            builder.error().ifPresent(this::error);
            this.threadId(builder.threadId());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER event(Event event) {
            Objects.requireNonNull(event);
            this.event = event;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMessage() {
            this.message = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER message(String message) {
            Objects.requireNonNull(message);
            this.message = message;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearActivationResult() {
            this.activationResult = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationResult(ActivationResult activationResult) {
            Objects.requireNonNull(activationResult);
            this.activationResult = activationResult;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationResult(Consumer<ActivationResult.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ActivationResult.Builder builder = ActivationResult.builder();
            consumer.accept(builder);
            this.activationResult(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServiceProvider() {
            this.serviceProvider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceProvider(ServiceProvider<?> serviceProvider) {
            Objects.requireNonNull(serviceProvider);
            this.serviceProvider = serviceProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInjectionPoint() {
            this.injectionPoint = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPoint(InjectionPointInfo injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPoint(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InjectionPointInfo.Builder builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPoint(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER time(Instant time) {
            Objects.requireNonNull(time);
            this.time = time;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearError() {
            this.error = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER error(Throwable error) {
            Objects.requireNonNull(error);
            this.error = error;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER threadId(long threadId) {
            this.threadId = threadId;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Event> event() {
            return Optional.ofNullable(this.event);
        }

        public Optional<String> message() {
            return Optional.ofNullable(this.message);
        }

        public Optional<ActivationResult> activationResult() {
            return Optional.ofNullable(this.activationResult);
        }

        public Optional<ServiceProvider<?>> serviceProvider() {
            return Optional.ofNullable(this.serviceProvider);
        }

        public Optional<InjectionPointInfo> injectionPoint() {
            return Optional.ofNullable(this.injectionPoint);
        }

        public Optional<Instant> time() {
            return Optional.ofNullable(this.time);
        }

        public Optional<Throwable> error() {
            return Optional.ofNullable(this.error);
        }

        public long threadId() {
            return this.threadId;
        }

        public String toString() {
            return "ActivationLogEntryBuilder{event=" + String.valueOf((Object)this.event) + ",message=" + this.message + ",activationResult=" + String.valueOf(this.activationResult) + ",serviceProvider=" + String.valueOf(this.serviceProvider) + ",injectionPoint=" + String.valueOf(this.injectionPoint) + ",time=" + String.valueOf(this.time) + ",error=" + String.valueOf(this.error) + ",threadId=" + this.threadId + "}";
        }

        protected void preBuildPrototype() {
            new ActivationLogEntryBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.event == null) {
                collector.fatal(this.getClass(), "Property \"event\" must not be null, but not set");
            }
            if (this.time == null) {
                collector.fatal(this.getClass(), "Property \"time\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER message(Optional<String> message) {
            Objects.requireNonNull(message);
            this.message = message.map(String.class::cast).orElse(this.message);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER activationResult(Optional<? extends ActivationResult> activationResult) {
            Objects.requireNonNull(activationResult);
            this.activationResult = activationResult.map(ActivationResult.class::cast).orElse(this.activationResult);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER serviceProvider(Optional<ServiceProvider<?>> serviceProvider) {
            Objects.requireNonNull(serviceProvider);
            this.serviceProvider = serviceProvider.map(ServiceProvider.class::cast).orElse(this.serviceProvider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER injectionPoint(Optional<? extends InjectionPointInfo> injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint.map(InjectionPointInfo.class::cast).orElse(this.injectionPoint);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER error(Optional<? extends Throwable> error) {
            Objects.requireNonNull(error);
            this.error = error.map(Throwable.class::cast).orElse(this.error);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ActivationLogEntryImpl
        implements ActivationLogEntry {
            private final Event event;
            private final Instant time;
            private final long threadId;
            private final Optional<ActivationResult> activationResult;
            private final Optional<InjectionPointInfo> injectionPoint;
            private final Optional<ServiceProvider<?>> serviceProvider;
            private final Optional<String> message;
            private final Optional<Throwable> error;

            protected ActivationLogEntryImpl(BuilderBase<?, ?> builder) {
                this.event = builder.event().get();
                this.message = builder.message();
                this.activationResult = builder.activationResult();
                this.serviceProvider = builder.serviceProvider();
                this.injectionPoint = builder.injectionPoint();
                this.time = builder.time().get();
                this.error = builder.error();
                this.threadId = builder.threadId();
            }

            @Override
            public Event event() {
                return this.event;
            }

            @Override
            public Optional<String> message() {
                return this.message;
            }

            @Override
            public Optional<ActivationResult> activationResult() {
                return this.activationResult;
            }

            @Override
            public Optional<ServiceProvider<?>> serviceProvider() {
                return this.serviceProvider;
            }

            @Override
            public Optional<InjectionPointInfo> injectionPoint() {
                return this.injectionPoint;
            }

            @Override
            public Instant time() {
                return this.time;
            }

            @Override
            public Optional<Throwable> error() {
                return this.error;
            }

            @Override
            public long threadId() {
                return this.threadId;
            }

            public String toString() {
                return "ActivationLogEntry{event=" + String.valueOf((Object)this.event) + ",message=" + String.valueOf(this.message) + ",activationResult=" + String.valueOf(this.activationResult) + ",serviceProvider=" + String.valueOf(this.serviceProvider) + ",injectionPoint=" + String.valueOf(this.injectionPoint) + ",time=" + String.valueOf(this.time) + ",error=" + String.valueOf(this.error) + ",threadId=" + this.threadId + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationLogEntry)) {
                    return false;
                }
                ActivationLogEntry other = (ActivationLogEntry)o;
                return Objects.equals((Object)this.event, (Object)other.event()) && Objects.equals(this.message, other.message()) && Objects.equals(this.activationResult, other.activationResult()) && Objects.equals(this.serviceProvider, other.serviceProvider()) && Objects.equals(this.injectionPoint, other.injectionPoint()) && Objects.equals(this.time, other.time()) && Objects.equals(this.error, other.error()) && this.threadId == other.threadId();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.event, this.message, this.activationResult, this.serviceProvider, this.injectionPoint, this.time, this.error, this.threadId});
            }
        }
    }
}

