/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.inject.api.BootstrapBlueprint;
import io.helidon.inject.api.Phase;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.BootstrapBlueprint")
public interface Bootstrap
extends BootstrapBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Bootstrap instance) {
        return (Builder)Bootstrap.builder().from(instance);
    }

    public static Bootstrap create() {
        return Bootstrap.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Bootstrap>
    implements io.helidon.common.Builder<Builder, Bootstrap> {
        private Builder() {
        }

        public Bootstrap buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.BootstrapImpl(this);
        }

        public Bootstrap build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Bootstrap>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private Phase limitRuntimePhase;

        protected BuilderBase() {
        }

        public BUILDER from(Bootstrap prototype) {
            this.config = prototype.config().orElse(null);
            this.limitRuntimePhase(prototype.limitRuntimePhase());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.config().ifPresent(config -> this.config((Config)config));
            builder.limitRuntimePhase().ifPresent(this::limitRuntimePhase);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLimitRuntimePhase() {
            this.limitRuntimePhase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER limitRuntimePhase(Phase limitRuntimePhase) {
            Objects.requireNonNull(limitRuntimePhase);
            this.limitRuntimePhase = limitRuntimePhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public Optional<Phase> limitRuntimePhase() {
            return Optional.ofNullable(this.limitRuntimePhase);
        }

        public String toString() {
            return "BootstrapBuilder{config=" + String.valueOf(this.config) + ",limitRuntimePhase=" + String.valueOf((Object)this.limitRuntimePhase) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER limitRuntimePhase(Optional<? extends Phase> limitRuntimePhase) {
            Objects.requireNonNull(limitRuntimePhase);
            this.limitRuntimePhase = limitRuntimePhase.map(Phase.class::cast).orElse(this.limitRuntimePhase);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class BootstrapImpl
        implements Bootstrap {
            private final Optional<Config> config;
            private final Optional<Phase> limitRuntimePhase;

            protected BootstrapImpl(BuilderBase<?, ?> builder) {
                this.config = builder.config();
                this.limitRuntimePhase = builder.limitRuntimePhase();
            }

            @Override
            public Optional<Config> config() {
                return this.config;
            }

            @Override
            public Optional<Phase> limitRuntimePhase() {
                return this.limitRuntimePhase;
            }

            public String toString() {
                return "Bootstrap{config=" + String.valueOf(this.config) + ",limitRuntimePhase=" + String.valueOf(this.limitRuntimePhase) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bootstrap)) {
                    return false;
                }
                Bootstrap other = (Bootstrap)o;
                return Objects.equals(this.config, other.config()) && Objects.equals(this.limitRuntimePhase, other.limitRuntimePhase());
            }

            public int hashCode() {
                return Objects.hash(this.config, this.limitRuntimePhase);
            }
        }
    }
}

