/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.inject.api.DependencyInfo;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.InjectionPointInfoBlueprint;
import java.io.Serializable;
import java.util.Comparator;

public class DependencyInfoComparator
implements Comparator<DependencyInfo>,
Serializable {
    private static final Comparator<DependencyInfo> INSTANCE = new DependencyInfoComparator();

    private DependencyInfoComparator() {
    }

    public static Comparator<DependencyInfo> instance() {
        return INSTANCE;
    }

    @Override
    public int compare(DependencyInfo o1, DependencyInfo o2) {
        InjectionPointInfo ipi1 = o1.injectionPointDependencies().iterator().next();
        InjectionPointInfo ipi2 = o2.injectionPointDependencies().iterator().next();
        Comparator<InjectionPointInfo> idComp = Comparator.comparing(InjectionPointInfoBlueprint::baseIdentity);
        Comparator<InjectionPointInfo> posComp = Comparator.comparing(DependencyInfoComparator::elementOffsetOf);
        return idComp.thenComparing(posComp).compare(ipi1, ipi2);
    }

    private static int elementOffsetOf(InjectionPointInfo ipi) {
        return ipi.elementOffset().orElse(0);
    }
}

