/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.ActivationRequest;
import io.helidon.inject.api.Injector;
import io.helidon.inject.api.InjectorOptionsBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.InjectorOptionsBlueprint")
public interface InjectorOptions
extends InjectorOptionsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InjectorOptions instance) {
        return (Builder)InjectorOptions.builder().from(instance);
    }

    public static InjectorOptions create() {
        return InjectorOptions.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InjectorOptions>
    implements io.helidon.common.Builder<Builder, InjectorOptions> {
        private Builder() {
        }

        public InjectorOptions buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InjectorOptionsImpl(this);
        }

        public InjectorOptions build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InjectorOptions>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private ActivationRequest activationRequest;
        private Injector.Strategy strategy = Injector.Strategy.ANY;

        protected BuilderBase() {
        }

        public BUILDER from(InjectorOptions prototype) {
            this.strategy(prototype.strategy());
            this.activationRequest(prototype.activationRequest());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.strategy(builder.strategy());
            builder.activationRequest().ifPresent(this::activationRequest);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER strategy(Injector.Strategy strategy) {
            Objects.requireNonNull(strategy);
            this.strategy = strategy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationRequest(ActivationRequest activationRequest) {
            Objects.requireNonNull(activationRequest);
            this.activationRequest = activationRequest;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationRequest(Consumer<ActivationRequest.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ActivationRequest.Builder builder = ActivationRequest.builder();
            consumer.accept(builder);
            this.activationRequest(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activationRequest(Supplier<? extends ActivationRequest> supplier) {
            Objects.requireNonNull(supplier);
            this.activationRequest(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Injector.Strategy strategy() {
            return this.strategy;
        }

        public Optional<ActivationRequest> activationRequest() {
            return Optional.ofNullable(this.activationRequest);
        }

        public String toString() {
            return "InjectorOptionsBuilder{strategy=" + String.valueOf((Object)this.strategy) + ",activationRequest=" + String.valueOf(this.activationRequest) + "}";
        }

        protected void preBuildPrototype() {
            new InjectorOptionsBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.activationRequest == null) {
                collector.fatal(this.getClass(), "Property \"activationRequest\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class InjectorOptionsImpl
        implements InjectorOptions {
            private final ActivationRequest activationRequest;
            private final Injector.Strategy strategy;

            protected InjectorOptionsImpl(BuilderBase<?, ?> builder) {
                this.strategy = builder.strategy();
                this.activationRequest = builder.activationRequest().get();
            }

            @Override
            public Injector.Strategy strategy() {
                return this.strategy;
            }

            @Override
            public ActivationRequest activationRequest() {
                return this.activationRequest;
            }

            public String toString() {
                return "InjectorOptions{strategy=" + String.valueOf((Object)this.strategy) + ",activationRequest=" + String.valueOf(this.activationRequest) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectorOptions)) {
                    return false;
                }
                InjectorOptions other = (InjectorOptions)o;
                return Objects.equals((Object)this.strategy, (Object)other.strategy()) && Objects.equals(this.activationRequest, other.activationRequest());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.strategy, this.activationRequest});
            }
        }
    }
}

