/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceFilter;
import io.kubernetes.client.openapi.models.V1alpha2VendorParameters;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1alpha2ResourceClassParameters
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FILTERS = "filters";
    @SerializedName(value="filters")
    private List<V1alpha2ResourceFilter> filters;
    public static final String SERIALIZED_NAME_GENERATED_FROM = "generatedFrom";
    @SerializedName(value="generatedFrom")
    private V1alpha2ResourceClassParametersReference generatedFrom;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_VENDOR_PARAMETERS = "vendorParameters";
    @SerializedName(value="vendorParameters")
    private List<V1alpha2VendorParameters> vendorParameters;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha2ResourceClassParameters apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceClassParameters filters(List<V1alpha2ResourceFilter> filters) {
        this.filters = filters;
        return this;
    }

    public V1alpha2ResourceClassParameters addFiltersItem(V1alpha2ResourceFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<V1alpha2ResourceFilter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nullable
    public List<V1alpha2ResourceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<V1alpha2ResourceFilter> filters) {
        this.filters = filters;
    }

    public V1alpha2ResourceClassParameters generatedFrom(V1alpha2ResourceClassParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
        return this;
    }

    @Nullable
    public V1alpha2ResourceClassParametersReference getGeneratedFrom() {
        return this.generatedFrom;
    }

    public void setGeneratedFrom(V1alpha2ResourceClassParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public V1alpha2ResourceClassParameters kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClassParameters metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceClassParameters vendorParameters(List<V1alpha2VendorParameters> vendorParameters) {
        this.vendorParameters = vendorParameters;
        return this;
    }

    public V1alpha2ResourceClassParameters addVendorParametersItem(V1alpha2VendorParameters vendorParametersItem) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList<V1alpha2VendorParameters>();
        }
        this.vendorParameters.add(vendorParametersItem);
        return this;
    }

    @Nullable
    public List<V1alpha2VendorParameters> getVendorParameters() {
        return this.vendorParameters;
    }

    public void setVendorParameters(List<V1alpha2VendorParameters> vendorParameters) {
        this.vendorParameters = vendorParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClassParameters v1alpha2ResourceClassParameters = (V1alpha2ResourceClassParameters)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceClassParameters.apiVersion) && Objects.equals(this.filters, v1alpha2ResourceClassParameters.filters) && Objects.equals(this.generatedFrom, v1alpha2ResourceClassParameters.generatedFrom) && Objects.equals(this.kind, v1alpha2ResourceClassParameters.kind) && Objects.equals(this.metadata, v1alpha2ResourceClassParameters.metadata) && Objects.equals(this.vendorParameters, v1alpha2ResourceClassParameters.vendorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.filters, this.generatedFrom, this.kind, this.metadata, this.vendorParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClassParameters {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    generatedFrom: ").append(this.toIndentedString(this.generatedFrom)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    vendorParameters: ").append(this.toIndentedString(this.vendorParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvendorParameters;
        JsonArray jsonArrayfilters;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha2ResourceClassParameters is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha2ResourceClassParameters` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILTERS) != null && !jsonObj.get(SERIALIZED_NAME_FILTERS).isJsonNull() && (jsonArrayfilters = jsonObj.getAsJsonArray(SERIALIZED_NAME_FILTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FILTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `filters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILTERS).toString()));
            }
            for (int i = 0; i < jsonArrayfilters.size(); ++i) {
                V1alpha2ResourceFilter.validateJsonObject(jsonArrayfilters.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_GENERATED_FROM) != null && !jsonObj.get(SERIALIZED_NAME_GENERATED_FROM).isJsonNull()) {
            V1alpha2ResourceClassParametersReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GENERATED_FROM));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_VENDOR_PARAMETERS) != null && !jsonObj.get(SERIALIZED_NAME_VENDOR_PARAMETERS).isJsonNull() && (jsonArrayvendorParameters = jsonObj.getAsJsonArray(SERIALIZED_NAME_VENDOR_PARAMETERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VENDOR_PARAMETERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `vendorParameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VENDOR_PARAMETERS).toString()));
            }
            for (int i = 0; i < jsonArrayvendorParameters.size(); ++i) {
                V1alpha2VendorParameters.validateJsonObject(jsonArrayvendorParameters.get(i).getAsJsonObject());
            }
        }
    }

    public static V1alpha2ResourceClassParameters fromJson(String jsonString) throws IOException {
        return (V1alpha2ResourceClassParameters)JSON.getGson().fromJson(jsonString, V1alpha2ResourceClassParameters.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_FILTERS);
        openapiFields.add(SERIALIZED_NAME_GENERATED_FROM);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_VENDOR_PARAMETERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha2ResourceClassParameters.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha2ResourceClassParameters.class));
            return new TypeAdapter<V1alpha2ResourceClassParameters>(){

                public void write(JsonWriter out, V1alpha2ResourceClassParameters value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha2ResourceClassParameters read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1alpha2ResourceClassParameters.validateJsonObject(jsonObj);
                    return (V1alpha2ResourceClassParameters)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

