/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.util.Objects;

public class Consumer<K> {
    final K group;
    final K name;

    private Consumer(K group, K name) {
        this.group = group;
        this.name = name;
    }

    public static <K> Consumer<K> from(K group, K name) {
        LettuceAssert.notNull(group, "Group must not be null");
        LettuceAssert.notNull(name, "Name must not be null");
        return new Consumer<K>(group, name);
    }

    public K getGroup() {
        return this.group;
    }

    public K getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Consumer)) {
            return false;
        }
        Consumer consumer = (Consumer)o;
        return Objects.equals(this.group, consumer.group) && Objects.equals(this.name, consumer.name);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name);
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }
}

