/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactory;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@Internal
public abstract class AbstractHttpClientFactory<T extends HttpClient>
implements HttpClientFactory {
    protected final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected final ConversionService conversionService;

    protected AbstractHttpClientFactory(@Nullable MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.conversionService = conversionService;
    }

    @NonNull
    protected abstract T createHttpClient(@Nullable URI var1);

    @NonNull
    protected abstract T createHttpClient(@Nullable URI var1, @NonNull HttpClientConfiguration var2);

    @Override
    @NonNull
    public HttpClient createClient(URL url) {
        return this.createHttpClient(url);
    }

    @Override
    @NonNull
    public HttpClient createClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createHttpClient(url, configuration);
    }

    private T createHttpClient(URL url) {
        try {
            return this.createHttpClient(url != null ? url.toURI() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NonNull
    private T createHttpClient(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        try {
            return this.createHttpClient(url != null ? url.toURI() : null, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

