/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.processing.JavaModelUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class ModelUtils {
    private static final Method RECORD_COMPONENTS_METHODS = ReflectionUtils.findMethod(TypeElement.class, (String)"getRecordComponents", (Class[])new Class[0]).orElse(null);
    private final Elements elementUtils;
    private final Types typeUtils;

    protected ModelUtils(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    @Nullable
    public final TypeElement classElementFor(javax.lang.model.element.Element element) {
        while (!(element == null || JavaModelUtils.isClassOrInterface((javax.lang.model.element.Element)element) || JavaModelUtils.isRecord((javax.lang.model.element.Element)element) || JavaModelUtils.isEnum((javax.lang.model.element.Element)element))) {
            element = element.getEnclosingElement();
        }
        if (element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return null;
    }

    String simpleBinaryNameFor(TypeElement typeElement) {
        Name elementBinaryName = this.elementUtils.getBinaryName(typeElement);
        PackageElement packageElement = this.elementUtils.getPackageOf(typeElement);
        String packageName = packageElement.getQualifiedName().toString();
        return elementBinaryName.toString().replaceFirst(packageName + "\\.", "");
    }

    Optional<ExecutableElement> findGetterMethodFor(javax.lang.model.element.Element field) {
        TypeElement typeElement = this.classElementFor(field);
        if (typeElement == null) {
            return Optional.empty();
        }
        String getterName = this.getterNameFor(field);
        List<? extends javax.lang.model.element.Element> elements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return methods.stream().filter(method -> {
            String methodName = method.getSimpleName().toString();
            if (getterName.equals(methodName)) {
                Set<Modifier> modifiers = method.getModifiers();
                return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED);
            }
            return false;
        }).findFirst();
    }

    Optional<ExecutableElement> findSetterMethodFor(javax.lang.model.element.Element field) {
        TypeElement typeElement;
        String name = field.getSimpleName().toString();
        if (field.asType().getKind() == TypeKind.BOOLEAN && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            name = name.replaceFirst("^(is)(.+)", "$2");
        }
        if ((typeElement = this.classElementFor(field)) == null) {
            return Optional.empty();
        }
        String setterName = this.setterNameFor(name);
        List<? extends javax.lang.model.element.Element> elements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return methods.stream().filter(method -> {
            String methodName = method.getSimpleName().toString();
            if (setterName.equals(methodName)) {
                Set<Modifier> modifiers = method.getModifiers();
                return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED);
            }
            return false;
        }).findFirst();
    }

    String getterNameFor(javax.lang.model.element.Element field) {
        String methodNamePrefix = "get";
        if (field.asType().getKind() == TypeKind.BOOLEAN) {
            methodNamePrefix = "is";
        }
        return methodNamePrefix + NameUtils.capitalize((String)field.getSimpleName().toString());
    }

    String setterNameFor(String fieldName) {
        return "set" + NameUtils.capitalize((String)fieldName);
    }

    @Nullable
    public ExecutableElement concreteConstructorFor(TypeElement classElement, AnnotationUtils annotationUtils) {
        if (JavaModelUtils.isRecord((javax.lang.model.element.Element)classElement)) {
            List recordComponents;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
            Optional<ExecutableElement> element = this.findAnnotatedConstructor(annotationUtils, constructors);
            if (element.isPresent()) {
                return element.get();
            }
            if (RECORD_COMPONENTS_METHODS != null && (recordComponents = (List)ReflectionUtils.invokeMethod((Object)classElement, (Method)RECORD_COMPONENTS_METHODS, (Object[])new Object[0])) != null) {
                block0: for (ExecutableElement constructor : constructors) {
                    List<? extends VariableElement> parameters = constructor.getParameters();
                    if (parameters.size() != recordComponents.size()) continue;
                    for (int i = 0; i < parameters.size(); ++i) {
                        TypeMirror rightType;
                        VariableElement vt = parameters.get(i);
                        javax.lang.model.element.Element rct = (javax.lang.model.element.Element)recordComponents.get(i);
                        TypeMirror leftType = this.typeUtils.erasure(vt.asType());
                        if (!leftType.equals(rightType = this.typeUtils.erasure(rct.asType()))) continue block0;
                    }
                    return constructor;
                }
            }
            return constructors.get(constructors.size() - 1);
        }
        List<ExecutableElement> constructors = this.findNonPrivateConstructors(classElement);
        if (constructors.isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        Optional<ExecutableElement> element = this.findAnnotatedConstructor(annotationUtils, constructors);
        if (!element.isPresent()) {
            element = constructors.stream().filter(ctor -> ctor.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst();
        }
        return element.orElse(null);
    }

    private Optional<ExecutableElement> findAnnotatedConstructor(AnnotationUtils annotationUtils, List<ExecutableElement> constructors) {
        return constructors.stream().filter(ctor -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)ctor);
            return annotationMetadata.hasStereotype("javax.inject.Inject") || annotationMetadata.hasStereotype(Creator.class);
        }).findFirst();
    }

    @Nullable
    public ExecutableElement staticCreatorFor(TypeElement classElement, AnnotationUtils annotationUtils) {
        List<ExecutableElement> creators = this.findNonPrivateStaticCreators(classElement, annotationUtils);
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        List withArgs = creators.stream().filter(method -> !method.getParameters().isEmpty()).collect(Collectors.toList());
        if (withArgs.size() == 1) {
            return (ExecutableElement)withArgs.get(0);
        }
        creators = withArgs;
        return creators.stream().filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst().orElse(null);
    }

    public ExecutableElement defaultConstructorFor(TypeElement classElement) {
        List constructors = this.findNonPrivateConstructors(classElement).stream().filter(ctor -> ctor.getParameters().isEmpty()).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return (ExecutableElement)constructors.get(0);
        }
        return constructors.stream().filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst().orElse(null);
    }

    public ExecutableElement defaultStaticCreatorFor(TypeElement classElement, AnnotationUtils annotationUtils) {
        List creators = this.findNonPrivateStaticCreators(classElement, annotationUtils).stream().filter(ctor -> ctor.getParameters().isEmpty()).collect(Collectors.toList());
        if (creators.isEmpty()) {
            return null;
        }
        if (creators.size() == 1) {
            return (ExecutableElement)creators.get(0);
        }
        return creators.stream().filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst().orElse(null);
    }

    public boolean isObjectClass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.NONE;
    }

    private List<ExecutableElement> findNonPrivateConstructors(TypeElement classElement) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
        return ctors.stream().filter(ctor -> !ctor.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toList());
    }

    private List<ExecutableElement> findNonPrivateStaticCreators(TypeElement classElement, AnnotationUtils annotationUtils) {
        List<? extends javax.lang.model.element.Element> enclosedElements = classElement.getEnclosedElements();
        List<ExecutableElement> staticCreators = ElementFilter.methodsIn(enclosedElements).stream().filter(method -> method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).filter(method -> this.typeUtils.isAssignable(this.typeUtils.erasure(method.getReturnType()), classElement.asType())).filter(method -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)method);
            return annotationMetadata.hasStereotype(Creator.class);
        }).collect(Collectors.toList());
        if (staticCreators.isEmpty()) {
            TypeElement companionClass = ElementFilter.typesIn(enclosedElements).stream().filter(type -> type.getSimpleName().toString().equals("Companion")).filter(type -> type.getModifiers().contains((Object)Modifier.STATIC)).findFirst().orElse(null);
            if (companionClass != null) {
                staticCreators = ElementFilter.methodsIn(companionClass.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).filter(method -> method.getReturnType().equals(classElement.asType())).filter(method -> {
                    AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)method);
                    return annotationMetadata.hasStereotype(Creator.class);
                }).collect(Collectors.toList());
            } else if (classElement.getKind() == ElementKind.ENUM) {
                staticCreators = ElementFilter.methodsIn(classElement.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).filter(method -> method.getReturnType().equals(classElement.asType())).filter(method -> method.getSimpleName().toString().equals("valueOf")).collect(Collectors.toList());
            }
        }
        return staticCreators;
    }

    TypeElement superClassFor(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    String resolveTypeName(TypeMirror type) {
        TypeMirror typeMirror = this.resolveTypeReference(type);
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        if (typeElement != null) {
            return this.elementUtils.getBinaryName(typeElement).toString();
        }
        return this.typeUtils.erasure(typeMirror).toString();
    }

    TypeMirror resolveTypeReference(TypeMirror type) {
        TypeKind typeKind = type.getKind();
        if (typeKind.isPrimitive()) {
            return type;
        }
        if (typeKind == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            if (dt.getTypeArguments().isEmpty()) {
                return dt;
            }
            return this.typeUtils.erasure(type);
        }
        return this.typeUtils.erasure(type);
    }

    public boolean isPackagePrivate(javax.lang.model.element.Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    public Set<TypeElement> getAllInterfaces(TypeElement aClass) {
        TreeSet<TypeElement> interfaces = new TreeSet<TypeElement>((o1, o2) -> {
            if (this.typeUtils.isSubtype(o1.asType(), o2.asType())) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        });
        return this.populateInterfaces(aClass, interfaces);
    }

    private Set<TypeElement> populateInterfaces(TypeElement aClass, Set<TypeElement> interfaces) {
        for (TypeMirror typeMirror : aClass.getInterfaces()) {
            TypeElement te;
            javax.lang.model.element.Element e = this.typeUtils.asElement(typeMirror);
            if (!(e instanceof TypeElement) || interfaces.contains(te = (TypeElement)e)) continue;
            interfaces.add(te);
            this.populateInterfaces(te, interfaces);
        }
        if (aClass.getKind() != ElementKind.INTERFACE) {
            javax.lang.model.element.Element element;
            TypeMirror superclass = aClass.getSuperclass();
            while (superclass != null && (element = this.typeUtils.asElement(superclass)) instanceof TypeElement) {
                TypeElement superTypeElement = (TypeElement)element;
                this.populateInterfaces(superTypeElement, interfaces);
                superclass = superTypeElement.getSuperclass();
            }
        }
        return interfaces;
    }

    boolean isInheritedAndNotPublic(TypeElement concreteClass, TypeElement declaringClass, javax.lang.model.element.Element methodOrField) {
        PackageElement packageOfDeclaringClass = this.elementUtils.getPackageOf(declaringClass);
        PackageElement packageOfConcreteClass = this.elementUtils.getPackageOf(concreteClass);
        return declaringClass != concreteClass && !packageOfDeclaringClass.getQualifiedName().equals(packageOfConcreteClass.getQualifiedName()) && (this.isProtected(methodOrField) || !this.isPublic(methodOrField));
    }

    boolean isInheritedAndNotPublic(ClassElement concreteClass, ClassElement declaringClass, Element methodOrField) {
        String packageOfDeclaringClass = declaringClass.getPackageName();
        String packageOfConcreteClass = concreteClass.getPackageName();
        return declaringClass != concreteClass && !packageOfDeclaringClass.equals(packageOfConcreteClass) && (methodOrField.isProtected() || !methodOrField.isPublic());
    }

    public Optional<ExecutableElement> overridingOrHidingMethod(ExecutableElement overridden, TypeElement classElement, boolean strict) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElement));
        for (ExecutableElement method : methods) {
            if (!(strict ? this.elementUtils.overrides(method, overridden, classElement) : !method.equals(overridden) && method.getSimpleName().equals(overridden.getSimpleName()))) continue;
            return Optional.of(method);
        }
        TypeElement superClass = this.superClassFor(classElement);
        if (superClass != null && !this.isObjectClass(superClass)) {
            return this.overridingOrHidingMethod(overridden, superClass, strict);
        }
        return Optional.empty();
    }

    boolean isPrivate(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    boolean isProtected(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    boolean isPublic(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isAbstract(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    boolean isStatic(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    boolean isFinal(javax.lang.model.element.Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    boolean isOptional(TypeMirror mirror) {
        return this.typeUtils.erasure(mirror).toString().equals(Optional.class.getName());
    }

    public Optional<ElementKind> resolveKind(javax.lang.model.element.Element element, ElementKind expected) {
        Optional<ElementKind> elementKind = this.resolveKind(element);
        if (elementKind.isPresent() && elementKind.get() == expected) {
            return elementKind;
        }
        return Optional.empty();
    }

    public Optional<ElementKind> resolveKind(javax.lang.model.element.Element element) {
        if (element != null) {
            try {
                ElementKind kind = element.getKind();
                return Optional.of(kind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

