/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public interface Session
extends MutableConvertibleValues<Object> {
    @NonNull
    public Instant getCreationTime();

    @NonNull
    public String getId();

    @NonNull
    public Instant getLastAccessedTime();

    public Session setLastAccessedTime(Instant var1);

    public Session setMaxInactiveInterval(Duration var1);

    public Duration getMaxInactiveInterval();

    public boolean isNew();

    public boolean isModified();

    default public Optional<Object> get(CharSequence attr) {
        return this.get(attr, Object.class);
    }

    default public boolean isExpired() {
        Duration maxInactiveInterval = this.getMaxInactiveInterval();
        if (maxInactiveInterval == null || maxInactiveInterval.isNegative()) {
            return false;
        }
        Instant now = Instant.now();
        return now.minus(maxInactiveInterval).compareTo(this.getLastAccessedTime()) >= 0;
    }
}

