/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.http.HttpRequest;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.HttpSessionFilter;
import java.util.Optional;

public class SessionForRequest {
    public static Session create(SessionStore sessionStore, HttpRequest<?> request) {
        Object session = sessionStore.newSession();
        request.getAttributes().put(HttpSessionFilter.SESSION_ATTRIBUTE, session);
        return session;
    }

    public static Optional<Session> find(HttpRequest<?> request) {
        return request.getAttributes().get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
    }

    public static Session findOrCreate(HttpRequest<?> request, SessionStore sessionStore) {
        return SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(sessionStore, request));
    }
}

