/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldSchemaOrBuilder;
import io.milvus.grpc.FieldState;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.KeyValuePairOrBuilder;
import io.milvus.grpc.SchemaProto;
import io.milvus.grpc.ValueField;
import io.milvus.grpc.ValueFieldOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FieldSchema
extends GeneratedMessageV3
implements FieldSchemaOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int FIELDID_FIELD_NUMBER = 1;
    private long fieldID_ = 0L;
    public static final int NAME_FIELD_NUMBER = 2;
    private volatile Object name_ = "";
    public static final int IS_PRIMARY_KEY_FIELD_NUMBER = 3;
    private boolean isPrimaryKey_ = false;
    public static final int DESCRIPTION_FIELD_NUMBER = 4;
    private volatile Object description_ = "";
    public static final int DATA_TYPE_FIELD_NUMBER = 5;
    private int dataType_ = 0;
    public static final int TYPE_PARAMS_FIELD_NUMBER = 6;
    private List<KeyValuePair> typeParams_;
    public static final int INDEX_PARAMS_FIELD_NUMBER = 7;
    private List<KeyValuePair> indexParams_;
    public static final int AUTOID_FIELD_NUMBER = 8;
    private boolean autoID_ = false;
    public static final int STATE_FIELD_NUMBER = 9;
    private int state_ = 0;
    public static final int ELEMENT_TYPE_FIELD_NUMBER = 10;
    private int elementType_ = 0;
    public static final int DEFAULT_VALUE_FIELD_NUMBER = 11;
    private ValueField defaultValue_;
    public static final int IS_DYNAMIC_FIELD_NUMBER = 12;
    private boolean isDynamic_ = false;
    public static final int IS_PARTITION_KEY_FIELD_NUMBER = 13;
    private boolean isPartitionKey_ = false;
    public static final int IS_CLUSTERING_KEY_FIELD_NUMBER = 14;
    private boolean isClusteringKey_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final FieldSchema DEFAULT_INSTANCE = new FieldSchema();
    private static final Parser<FieldSchema> PARSER = new AbstractParser<FieldSchema>(){

        public FieldSchema parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = FieldSchema.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private FieldSchema(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private FieldSchema() {
        this.name_ = "";
        this.description_ = "";
        this.dataType_ = 0;
        this.typeParams_ = Collections.emptyList();
        this.indexParams_ = Collections.emptyList();
        this.state_ = 0;
        this.elementType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new FieldSchema();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SchemaProto.internal_static_milvus_proto_schema_FieldSchema_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SchemaProto.internal_static_milvus_proto_schema_FieldSchema_fieldAccessorTable.ensureFieldAccessorsInitialized(FieldSchema.class, Builder.class);
    }

    @Override
    public long getFieldID() {
        return this.fieldID_;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getIsPrimaryKey() {
        return this.isPrimaryKey_;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getDataTypeValue() {
        return this.dataType_;
    }

    @Override
    public DataType getDataType() {
        DataType result = DataType.forNumber(this.dataType_);
        return result == null ? DataType.UNRECOGNIZED : result;
    }

    @Override
    public List<KeyValuePair> getTypeParamsList() {
        return this.typeParams_;
    }

    @Override
    public List<? extends KeyValuePairOrBuilder> getTypeParamsOrBuilderList() {
        return this.typeParams_;
    }

    @Override
    public int getTypeParamsCount() {
        return this.typeParams_.size();
    }

    @Override
    public KeyValuePair getTypeParams(int index) {
        return this.typeParams_.get(index);
    }

    @Override
    public KeyValuePairOrBuilder getTypeParamsOrBuilder(int index) {
        return this.typeParams_.get(index);
    }

    @Override
    public List<KeyValuePair> getIndexParamsList() {
        return this.indexParams_;
    }

    @Override
    public List<? extends KeyValuePairOrBuilder> getIndexParamsOrBuilderList() {
        return this.indexParams_;
    }

    @Override
    public int getIndexParamsCount() {
        return this.indexParams_.size();
    }

    @Override
    public KeyValuePair getIndexParams(int index) {
        return this.indexParams_.get(index);
    }

    @Override
    public KeyValuePairOrBuilder getIndexParamsOrBuilder(int index) {
        return this.indexParams_.get(index);
    }

    @Override
    public boolean getAutoID() {
        return this.autoID_;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public FieldState getState() {
        FieldState result = FieldState.forNumber(this.state_);
        return result == null ? FieldState.UNRECOGNIZED : result;
    }

    @Override
    public int getElementTypeValue() {
        return this.elementType_;
    }

    @Override
    public DataType getElementType() {
        DataType result = DataType.forNumber(this.elementType_);
        return result == null ? DataType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDefaultValue() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public ValueField getDefaultValue() {
        return this.defaultValue_ == null ? ValueField.getDefaultInstance() : this.defaultValue_;
    }

    @Override
    public ValueFieldOrBuilder getDefaultValueOrBuilder() {
        return this.defaultValue_ == null ? ValueField.getDefaultInstance() : this.defaultValue_;
    }

    @Override
    public boolean getIsDynamic() {
        return this.isDynamic_;
    }

    @Override
    public boolean getIsPartitionKey() {
        return this.isPartitionKey_;
    }

    @Override
    public boolean getIsClusteringKey() {
        return this.isClusteringKey_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.fieldID_ != 0L) {
            output.writeInt64(1, this.fieldID_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.name_);
        }
        if (this.isPrimaryKey_) {
            output.writeBool(3, this.isPrimaryKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.description_);
        }
        if (this.dataType_ != DataType.None.getNumber()) {
            output.writeEnum(5, this.dataType_);
        }
        for (i = 0; i < this.typeParams_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.typeParams_.get(i));
        }
        for (i = 0; i < this.indexParams_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.indexParams_.get(i));
        }
        if (this.autoID_) {
            output.writeBool(8, this.autoID_);
        }
        if (this.state_ != FieldState.FieldCreated.getNumber()) {
            output.writeEnum(9, this.state_);
        }
        if (this.elementType_ != DataType.None.getNumber()) {
            output.writeEnum(10, this.elementType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(11, (MessageLite)this.getDefaultValue());
        }
        if (this.isDynamic_) {
            output.writeBool(12, this.isDynamic_);
        }
        if (this.isPartitionKey_) {
            output.writeBool(13, this.isPartitionKey_);
        }
        if (this.isClusteringKey_) {
            output.writeBool(14, this.isClusteringKey_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.fieldID_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)1, (long)this.fieldID_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.name_);
        }
        if (this.isPrimaryKey_) {
            size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.isPrimaryKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.description_);
        }
        if (this.dataType_ != DataType.None.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.dataType_);
        }
        for (i = 0; i < this.typeParams_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.typeParams_.get(i)));
        }
        for (i = 0; i < this.indexParams_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.indexParams_.get(i)));
        }
        if (this.autoID_) {
            size += CodedOutputStream.computeBoolSize((int)8, (boolean)this.autoID_);
        }
        if (this.state_ != FieldState.FieldCreated.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.state_);
        }
        if (this.elementType_ != DataType.None.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.elementType_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getDefaultValue());
        }
        if (this.isDynamic_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.isDynamic_);
        }
        if (this.isPartitionKey_) {
            size += CodedOutputStream.computeBoolSize((int)13, (boolean)this.isPartitionKey_);
        }
        if (this.isClusteringKey_) {
            size += CodedOutputStream.computeBoolSize((int)14, (boolean)this.isClusteringKey_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldSchema)) {
            return super.equals(obj);
        }
        FieldSchema other = (FieldSchema)obj;
        if (this.getFieldID() != other.getFieldID()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getIsPrimaryKey() != other.getIsPrimaryKey()) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.dataType_ != other.dataType_) {
            return false;
        }
        if (!this.getTypeParamsList().equals(other.getTypeParamsList())) {
            return false;
        }
        if (!this.getIndexParamsList().equals(other.getIndexParamsList())) {
            return false;
        }
        if (this.getAutoID() != other.getAutoID()) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (this.elementType_ != other.elementType_) {
            return false;
        }
        if (this.hasDefaultValue() != other.hasDefaultValue()) {
            return false;
        }
        if (this.hasDefaultValue() && !this.getDefaultValue().equals(other.getDefaultValue())) {
            return false;
        }
        if (this.getIsDynamic() != other.getIsDynamic()) {
            return false;
        }
        if (this.getIsPartitionKey() != other.getIsPartitionKey()) {
            return false;
        }
        if (this.getIsClusteringKey() != other.getIsClusteringKey()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + FieldSchema.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + Internal.hashLong((long)this.getFieldID());
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsPrimaryKey());
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.dataType_;
        if (this.getTypeParamsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getTypeParamsList().hashCode();
        }
        if (this.getIndexParamsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getIndexParamsList().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAutoID());
        hash = 37 * hash + 9;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 10;
        hash = 53 * hash + this.elementType_;
        if (this.hasDefaultValue()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getDefaultValue().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsDynamic());
        hash = 37 * hash + 13;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsPartitionKey());
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsClusteringKey());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static FieldSchema parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data);
    }

    public static FieldSchema parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FieldSchema parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data);
    }

    public static FieldSchema parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FieldSchema parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data);
    }

    public static FieldSchema parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FieldSchema)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FieldSchema parseFrom(InputStream input) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static FieldSchema parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static FieldSchema parseDelimitedFrom(InputStream input) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static FieldSchema parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static FieldSchema parseFrom(CodedInputStream input) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static FieldSchema parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FieldSchema)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return FieldSchema.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FieldSchema prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static FieldSchema getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<FieldSchema> parser() {
        return PARSER;
    }

    public Parser<FieldSchema> getParserForType() {
        return PARSER;
    }

    public FieldSchema getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements FieldSchemaOrBuilder {
        private int bitField0_;
        private long fieldID_;
        private Object name_ = "";
        private boolean isPrimaryKey_;
        private Object description_ = "";
        private int dataType_ = 0;
        private List<KeyValuePair> typeParams_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> typeParamsBuilder_;
        private List<KeyValuePair> indexParams_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> indexParamsBuilder_;
        private boolean autoID_;
        private int state_ = 0;
        private int elementType_ = 0;
        private ValueField defaultValue_;
        private SingleFieldBuilderV3<ValueField, ValueField.Builder, ValueFieldOrBuilder> defaultValueBuilder_;
        private boolean isDynamic_;
        private boolean isPartitionKey_;
        private boolean isClusteringKey_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SchemaProto.internal_static_milvus_proto_schema_FieldSchema_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SchemaProto.internal_static_milvus_proto_schema_FieldSchema_fieldAccessorTable.ensureFieldAccessorsInitialized(FieldSchema.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getTypeParamsFieldBuilder();
                this.getIndexParamsFieldBuilder();
                this.getDefaultValueFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.fieldID_ = 0L;
            this.name_ = "";
            this.isPrimaryKey_ = false;
            this.description_ = "";
            this.dataType_ = 0;
            if (this.typeParamsBuilder_ == null) {
                this.typeParams_ = Collections.emptyList();
            } else {
                this.typeParams_ = null;
                this.typeParamsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            if (this.indexParamsBuilder_ == null) {
                this.indexParams_ = Collections.emptyList();
            } else {
                this.indexParams_ = null;
                this.indexParamsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.autoID_ = false;
            this.state_ = 0;
            this.elementType_ = 0;
            this.defaultValue_ = null;
            if (this.defaultValueBuilder_ != null) {
                this.defaultValueBuilder_.dispose();
                this.defaultValueBuilder_ = null;
            }
            this.isDynamic_ = false;
            this.isPartitionKey_ = false;
            this.isClusteringKey_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SchemaProto.internal_static_milvus_proto_schema_FieldSchema_descriptor;
        }

        public FieldSchema getDefaultInstanceForType() {
            return FieldSchema.getDefaultInstance();
        }

        public FieldSchema build() {
            FieldSchema result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public FieldSchema buildPartial() {
            FieldSchema result = new FieldSchema(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(FieldSchema result) {
            if (this.typeParamsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.typeParams_ = Collections.unmodifiableList(this.typeParams_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.typeParams_ = this.typeParams_;
            } else {
                result.typeParams_ = this.typeParamsBuilder_.build();
            }
            if (this.indexParamsBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.indexParams_ = Collections.unmodifiableList(this.indexParams_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.indexParams_ = this.indexParams_;
            } else {
                result.indexParams_ = this.indexParamsBuilder_.build();
            }
        }

        private void buildPartial0(FieldSchema result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.fieldID_ = this.fieldID_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.isPrimaryKey_ = this.isPrimaryKey_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.dataType_ = this.dataType_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.autoID_ = this.autoID_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.elementType_ = this.elementType_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x400) != 0) {
                result.defaultValue_ = this.defaultValueBuilder_ == null ? this.defaultValue_ : (ValueField)this.defaultValueBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.isDynamic_ = this.isDynamic_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.isPartitionKey_ = this.isPartitionKey_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.isClusteringKey_ = this.isClusteringKey_;
            }
            FieldSchema fieldSchema = result;
            fieldSchema.bitField0_ = fieldSchema.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof FieldSchema) {
                return this.mergeFrom((FieldSchema)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(FieldSchema other) {
            if (other == FieldSchema.getDefaultInstance()) {
                return this;
            }
            if (other.getFieldID() != 0L) {
                this.setFieldID(other.getFieldID());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.getIsPrimaryKey()) {
                this.setIsPrimaryKey(other.getIsPrimaryKey());
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.dataType_ != 0) {
                this.setDataTypeValue(other.getDataTypeValue());
            }
            if (this.typeParamsBuilder_ == null) {
                if (!other.typeParams_.isEmpty()) {
                    if (this.typeParams_.isEmpty()) {
                        this.typeParams_ = other.typeParams_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureTypeParamsIsMutable();
                        this.typeParams_.addAll(other.typeParams_);
                    }
                    this.onChanged();
                }
            } else if (!other.typeParams_.isEmpty()) {
                if (this.typeParamsBuilder_.isEmpty()) {
                    this.typeParamsBuilder_.dispose();
                    this.typeParamsBuilder_ = null;
                    this.typeParams_ = other.typeParams_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.typeParamsBuilder_ = alwaysUseFieldBuilders ? this.getTypeParamsFieldBuilder() : null;
                } else {
                    this.typeParamsBuilder_.addAllMessages((Iterable)other.typeParams_);
                }
            }
            if (this.indexParamsBuilder_ == null) {
                if (!other.indexParams_.isEmpty()) {
                    if (this.indexParams_.isEmpty()) {
                        this.indexParams_ = other.indexParams_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureIndexParamsIsMutable();
                        this.indexParams_.addAll(other.indexParams_);
                    }
                    this.onChanged();
                }
            } else if (!other.indexParams_.isEmpty()) {
                if (this.indexParamsBuilder_.isEmpty()) {
                    this.indexParamsBuilder_.dispose();
                    this.indexParamsBuilder_ = null;
                    this.indexParams_ = other.indexParams_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.indexParamsBuilder_ = alwaysUseFieldBuilders ? this.getIndexParamsFieldBuilder() : null;
                } else {
                    this.indexParamsBuilder_.addAllMessages((Iterable)other.indexParams_);
                }
            }
            if (other.getAutoID()) {
                this.setAutoID(other.getAutoID());
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (other.elementType_ != 0) {
                this.setElementTypeValue(other.getElementTypeValue());
            }
            if (other.hasDefaultValue()) {
                this.mergeDefaultValue(other.getDefaultValue());
            }
            if (other.getIsDynamic()) {
                this.setIsDynamic(other.getIsDynamic());
            }
            if (other.getIsPartitionKey()) {
                this.setIsPartitionKey(other.getIsPartitionKey());
            }
            if (other.getIsClusteringKey()) {
                this.setIsClusteringKey(other.getIsClusteringKey());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 8: {
                            this.fieldID_ = input.readInt64();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 18: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                        case 24: {
                            this.isPrimaryKey_ = input.readBool();
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 34: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 40: {
                            this.dataType_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 50: {
                            KeyValuePair m = (KeyValuePair)input.readMessage(KeyValuePair.parser(), extensionRegistry);
                            if (this.typeParamsBuilder_ == null) {
                                this.ensureTypeParamsIsMutable();
                                this.typeParams_.add(m);
                                continue block22;
                            }
                            this.typeParamsBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 58: {
                            KeyValuePair m = (KeyValuePair)input.readMessage(KeyValuePair.parser(), extensionRegistry);
                            if (this.indexParamsBuilder_ == null) {
                                this.ensureIndexParamsIsMutable();
                                this.indexParams_.add(m);
                                continue block22;
                            }
                            this.indexParamsBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 64: {
                            this.autoID_ = input.readBool();
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 72: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 80: {
                            this.elementType_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block22;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getDefaultValueFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 96: {
                            this.isDynamic_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 104: {
                            this.isPartitionKey_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 112: {
                            this.isClusteringKey_ = input.readBool();
                            this.bitField0_ |= 0x2000;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public long getFieldID() {
            return this.fieldID_;
        }

        public Builder setFieldID(long value) {
            this.fieldID_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearFieldID() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.fieldID_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = FieldSchema.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            FieldSchema.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIsPrimaryKey() {
            return this.isPrimaryKey_;
        }

        public Builder setIsPrimaryKey(boolean value) {
            this.isPrimaryKey_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearIsPrimaryKey() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.isPrimaryKey_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = FieldSchema.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            FieldSchema.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getDataTypeValue() {
            return this.dataType_;
        }

        public Builder setDataTypeValue(int value) {
            this.dataType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public DataType getDataType() {
            DataType result = DataType.forNumber(this.dataType_);
            return result == null ? DataType.UNRECOGNIZED : result;
        }

        public Builder setDataType(DataType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.dataType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDataType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.dataType_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTypeParamsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.typeParams_ = new ArrayList<KeyValuePair>(this.typeParams_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<KeyValuePair> getTypeParamsList() {
            if (this.typeParamsBuilder_ == null) {
                return Collections.unmodifiableList(this.typeParams_);
            }
            return this.typeParamsBuilder_.getMessageList();
        }

        @Override
        public int getTypeParamsCount() {
            if (this.typeParamsBuilder_ == null) {
                return this.typeParams_.size();
            }
            return this.typeParamsBuilder_.getCount();
        }

        @Override
        public KeyValuePair getTypeParams(int index) {
            if (this.typeParamsBuilder_ == null) {
                return this.typeParams_.get(index);
            }
            return (KeyValuePair)this.typeParamsBuilder_.getMessage(index);
        }

        public Builder setTypeParams(int index, KeyValuePair value) {
            if (this.typeParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTypeParamsIsMutable();
                this.typeParams_.set(index, value);
                this.onChanged();
            } else {
                this.typeParamsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setTypeParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.typeParamsBuilder_ == null) {
                this.ensureTypeParamsIsMutable();
                this.typeParams_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.typeParamsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTypeParams(KeyValuePair value) {
            if (this.typeParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTypeParamsIsMutable();
                this.typeParams_.add(value);
                this.onChanged();
            } else {
                this.typeParamsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addTypeParams(int index, KeyValuePair value) {
            if (this.typeParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTypeParamsIsMutable();
                this.typeParams_.add(index, value);
                this.onChanged();
            } else {
                this.typeParamsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addTypeParams(KeyValuePair.Builder builderForValue) {
            if (this.typeParamsBuilder_ == null) {
                this.ensureTypeParamsIsMutable();
                this.typeParams_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.typeParamsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTypeParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.typeParamsBuilder_ == null) {
                this.ensureTypeParamsIsMutable();
                this.typeParams_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.typeParamsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTypeParams(Iterable<? extends KeyValuePair> values) {
            if (this.typeParamsBuilder_ == null) {
                this.ensureTypeParamsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.typeParams_);
                this.onChanged();
            } else {
                this.typeParamsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTypeParams() {
            if (this.typeParamsBuilder_ == null) {
                this.typeParams_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.typeParamsBuilder_.clear();
            }
            return this;
        }

        public Builder removeTypeParams(int index) {
            if (this.typeParamsBuilder_ == null) {
                this.ensureTypeParamsIsMutable();
                this.typeParams_.remove(index);
                this.onChanged();
            } else {
                this.typeParamsBuilder_.remove(index);
            }
            return this;
        }

        public KeyValuePair.Builder getTypeParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getTypeParamsFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValuePairOrBuilder getTypeParamsOrBuilder(int index) {
            if (this.typeParamsBuilder_ == null) {
                return this.typeParams_.get(index);
            }
            return (KeyValuePairOrBuilder)this.typeParamsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValuePairOrBuilder> getTypeParamsOrBuilderList() {
            if (this.typeParamsBuilder_ != null) {
                return this.typeParamsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.typeParams_);
        }

        public KeyValuePair.Builder addTypeParamsBuilder() {
            return (KeyValuePair.Builder)this.getTypeParamsFieldBuilder().addBuilder((AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public KeyValuePair.Builder addTypeParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getTypeParamsFieldBuilder().addBuilder(index, (AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public List<KeyValuePair.Builder> getTypeParamsBuilderList() {
            return this.getTypeParamsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> getTypeParamsFieldBuilder() {
            if (this.typeParamsBuilder_ == null) {
                this.typeParamsBuilder_ = new RepeatedFieldBuilderV3(this.typeParams_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.typeParams_ = null;
            }
            return this.typeParamsBuilder_;
        }

        private void ensureIndexParamsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.indexParams_ = new ArrayList<KeyValuePair>(this.indexParams_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<KeyValuePair> getIndexParamsList() {
            if (this.indexParamsBuilder_ == null) {
                return Collections.unmodifiableList(this.indexParams_);
            }
            return this.indexParamsBuilder_.getMessageList();
        }

        @Override
        public int getIndexParamsCount() {
            if (this.indexParamsBuilder_ == null) {
                return this.indexParams_.size();
            }
            return this.indexParamsBuilder_.getCount();
        }

        @Override
        public KeyValuePair getIndexParams(int index) {
            if (this.indexParamsBuilder_ == null) {
                return this.indexParams_.get(index);
            }
            return (KeyValuePair)this.indexParamsBuilder_.getMessage(index);
        }

        public Builder setIndexParams(int index, KeyValuePair value) {
            if (this.indexParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIndexParamsIsMutable();
                this.indexParams_.set(index, value);
                this.onChanged();
            } else {
                this.indexParamsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setIndexParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.indexParamsBuilder_ == null) {
                this.ensureIndexParamsIsMutable();
                this.indexParams_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.indexParamsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addIndexParams(KeyValuePair value) {
            if (this.indexParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIndexParamsIsMutable();
                this.indexParams_.add(value);
                this.onChanged();
            } else {
                this.indexParamsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addIndexParams(int index, KeyValuePair value) {
            if (this.indexParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIndexParamsIsMutable();
                this.indexParams_.add(index, value);
                this.onChanged();
            } else {
                this.indexParamsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addIndexParams(KeyValuePair.Builder builderForValue) {
            if (this.indexParamsBuilder_ == null) {
                this.ensureIndexParamsIsMutable();
                this.indexParams_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.indexParamsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addIndexParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.indexParamsBuilder_ == null) {
                this.ensureIndexParamsIsMutable();
                this.indexParams_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.indexParamsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllIndexParams(Iterable<? extends KeyValuePair> values) {
            if (this.indexParamsBuilder_ == null) {
                this.ensureIndexParamsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.indexParams_);
                this.onChanged();
            } else {
                this.indexParamsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearIndexParams() {
            if (this.indexParamsBuilder_ == null) {
                this.indexParams_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.indexParamsBuilder_.clear();
            }
            return this;
        }

        public Builder removeIndexParams(int index) {
            if (this.indexParamsBuilder_ == null) {
                this.ensureIndexParamsIsMutable();
                this.indexParams_.remove(index);
                this.onChanged();
            } else {
                this.indexParamsBuilder_.remove(index);
            }
            return this;
        }

        public KeyValuePair.Builder getIndexParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getIndexParamsFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValuePairOrBuilder getIndexParamsOrBuilder(int index) {
            if (this.indexParamsBuilder_ == null) {
                return this.indexParams_.get(index);
            }
            return (KeyValuePairOrBuilder)this.indexParamsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValuePairOrBuilder> getIndexParamsOrBuilderList() {
            if (this.indexParamsBuilder_ != null) {
                return this.indexParamsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.indexParams_);
        }

        public KeyValuePair.Builder addIndexParamsBuilder() {
            return (KeyValuePair.Builder)this.getIndexParamsFieldBuilder().addBuilder((AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public KeyValuePair.Builder addIndexParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getIndexParamsFieldBuilder().addBuilder(index, (AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public List<KeyValuePair.Builder> getIndexParamsBuilderList() {
            return this.getIndexParamsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> getIndexParamsFieldBuilder() {
            if (this.indexParamsBuilder_ == null) {
                this.indexParamsBuilder_ = new RepeatedFieldBuilderV3(this.indexParams_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.indexParams_ = null;
            }
            return this.indexParamsBuilder_;
        }

        @Override
        public boolean getAutoID() {
            return this.autoID_;
        }

        public Builder setAutoID(boolean value) {
            this.autoID_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearAutoID() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.autoID_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public FieldState getState() {
            FieldState result = FieldState.forNumber(this.state_);
            return result == null ? FieldState.UNRECOGNIZED : result;
        }

        public Builder setState(FieldState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getElementTypeValue() {
            return this.elementType_;
        }

        public Builder setElementTypeValue(int value) {
            this.elementType_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public DataType getElementType() {
            DataType result = DataType.forNumber(this.elementType_);
            return result == null ? DataType.UNRECOGNIZED : result;
        }

        public Builder setElementType(DataType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.elementType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearElementType() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.elementType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDefaultValue() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public ValueField getDefaultValue() {
            if (this.defaultValueBuilder_ == null) {
                return this.defaultValue_ == null ? ValueField.getDefaultInstance() : this.defaultValue_;
            }
            return (ValueField)this.defaultValueBuilder_.getMessage();
        }

        public Builder setDefaultValue(ValueField value) {
            if (this.defaultValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.defaultValue_ = value;
            } else {
                this.defaultValueBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setDefaultValue(ValueField.Builder builderForValue) {
            if (this.defaultValueBuilder_ == null) {
                this.defaultValue_ = builderForValue.build();
            } else {
                this.defaultValueBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeDefaultValue(ValueField value) {
            if (this.defaultValueBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.defaultValue_ != null && this.defaultValue_ != ValueField.getDefaultInstance()) {
                    this.getDefaultValueBuilder().mergeFrom(value);
                } else {
                    this.defaultValue_ = value;
                }
            } else {
                this.defaultValueBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.defaultValue_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDefaultValue() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.defaultValue_ = null;
            if (this.defaultValueBuilder_ != null) {
                this.defaultValueBuilder_.dispose();
                this.defaultValueBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ValueField.Builder getDefaultValueBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (ValueField.Builder)this.getDefaultValueFieldBuilder().getBuilder();
        }

        @Override
        public ValueFieldOrBuilder getDefaultValueOrBuilder() {
            if (this.defaultValueBuilder_ != null) {
                return (ValueFieldOrBuilder)this.defaultValueBuilder_.getMessageOrBuilder();
            }
            return this.defaultValue_ == null ? ValueField.getDefaultInstance() : this.defaultValue_;
        }

        private SingleFieldBuilderV3<ValueField, ValueField.Builder, ValueFieldOrBuilder> getDefaultValueFieldBuilder() {
            if (this.defaultValueBuilder_ == null) {
                this.defaultValueBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDefaultValue(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.defaultValue_ = null;
            }
            return this.defaultValueBuilder_;
        }

        @Override
        public boolean getIsDynamic() {
            return this.isDynamic_;
        }

        public Builder setIsDynamic(boolean value) {
            this.isDynamic_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearIsDynamic() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.isDynamic_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIsPartitionKey() {
            return this.isPartitionKey_;
        }

        public Builder setIsPartitionKey(boolean value) {
            this.isPartitionKey_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearIsPartitionKey() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.isPartitionKey_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIsClusteringKey() {
            return this.isClusteringKey_;
        }

        public Builder setIsClusteringKey(boolean value) {
            this.isClusteringKey_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearIsClusteringKey() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.isClusteringKey_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

