/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1;

import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.service.NflowNotFoundException;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.v1.converter.ListWorkflowDefinitionConverter;
import io.nflow.rest.v1.converter.ListWorkflowInstanceConverter;
import io.nflow.rest.v1.msg.ErrorResponse;
import io.nflow.rest.v1.msg.ListWorkflowDefinitionResponse;
import io.nflow.rest.v1.msg.ListWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.UpdateWorkflowInstanceRequest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.StringUtils;

public abstract class ResourceBase {
    protected static final String currentStateVariables = "currentStateVariables";
    protected static final String actions = "actions";
    protected static final String actionStateVariables = "actionStateVariables";
    protected static final String childWorkflows = "childWorkflows";
    protected static final String INCLUDE_PARAM_VALUES = "currentStateVariables,actions,actionStateVariables,childWorkflows";
    protected static final String INCLUDE_PARAM_DESC = "Data to include in response. currentStateVariables = current stateVariables for worfklow, actions = state transitions, actionStateVariables = state variable changes for actions, childWorkflows = map of created child workflow instance IDs by action ID";
    private static final Map<String, WorkflowInstanceInclude> INCLUDE_STRING_TO_ENUM = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, WorkflowInstanceInclude>("currentStateVariables", WorkflowInstanceInclude.CURRENT_STATE_VARIABLES), new AbstractMap.SimpleEntry<String, WorkflowInstanceInclude>("actions", WorkflowInstanceInclude.ACTIONS), new AbstractMap.SimpleEntry<String, WorkflowInstanceInclude>("actionStateVariables", WorkflowInstanceInclude.ACTION_STATE_VARIABLES), new AbstractMap.SimpleEntry<String, WorkflowInstanceInclude>("childWorkflows", WorkflowInstanceInclude.CHILD_WORKFLOW_IDS)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

    public List<ListWorkflowDefinitionResponse> listWorkflowDefinitions(List<String> types, WorkflowDefinitionService workflowDefinitions, ListWorkflowDefinitionConverter converter, WorkflowDefinitionDao workflowDefinitionDao) {
        List definitions = workflowDefinitions.getWorkflowDefinitions();
        HashSet<String> reqTypes = new HashSet<String>(types);
        HashSet<String> foundTypes = new HashSet<String>();
        ArrayList<ListWorkflowDefinitionResponse> response = new ArrayList<ListWorkflowDefinitionResponse>();
        for (AbstractWorkflowDefinition definition : definitions) {
            if (!reqTypes.isEmpty() && !reqTypes.contains(definition.getType())) continue;
            foundTypes.add(definition.getType());
            response.add(converter.convert((AbstractWorkflowDefinition<? extends WorkflowState>)definition));
        }
        if (reqTypes.isEmpty() || foundTypes.size() < reqTypes.size()) {
            reqTypes.removeAll(foundTypes);
            List storedDefinitions = workflowDefinitionDao.queryStoredWorkflowDefinitions(reqTypes);
            for (StoredWorkflowDefinition storedDefinition : storedDefinitions) {
                if (foundTypes.contains(storedDefinition.type)) continue;
                response.add(converter.convert(storedDefinition));
            }
        }
        Collections.sort(response);
        return response;
    }

    public boolean updateWorkflowInstance(long id, UpdateWorkflowInstanceRequest req, WorkflowInstanceFactory workflowInstanceFactory, WorkflowInstanceService workflowInstances, WorkflowInstanceDao workflowInstanceDao) {
        WorkflowInstance.Builder builder = workflowInstanceFactory.newWorkflowInstanceBuilder().setId(id).setNextActivation(req.nextActivationTime);
        String msg = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)req.actionDescription, (CharSequence)"");
        if (!StringUtils.isEmpty((Object)req.state)) {
            builder.setState(req.state);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = "API changed state to " + req.state + ". ";
            }
        }
        if (req.nextActivationTime != null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
            msg = msg + "API changed nextActivationTime to " + req.nextActivationTime + ". ";
        }
        if (!req.stateVariables.isEmpty()) {
            for (Map.Entry<String, Object> entry : req.stateVariables.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    builder.putStateVariable(entry.getKey(), (String)value);
                    continue;
                }
                builder.putStateVariable(entry.getKey(), value);
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = msg + "API updated state variables. ";
            }
        }
        if (!StringUtils.isEmpty((Object)req.businessKey)) {
            builder.setBusinessKey(req.businessKey);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = "API changed business key to " + req.businessKey + ". ";
            }
        }
        if (msg.isEmpty()) {
            return true;
        }
        WorkflowInstance instance = builder.setStateText(msg).build();
        instance.getChangedStateVariables().forEach((arg_0, arg_1) -> ((WorkflowInstanceDao)workflowInstanceDao).checkStateVariableValueLength(arg_0, arg_1));
        WorkflowInstanceAction action = new WorkflowInstanceAction.Builder(instance).setType(WorkflowInstanceAction.WorkflowActionType.externalChange).setStateText(org.apache.commons.lang3.StringUtils.trimToNull((String)msg)).setExecutionEnd(DateTime.now()).build();
        return workflowInstances.updateWorkflowInstance(instance, action);
    }

    public Stream<ListWorkflowInstanceResponse> listWorkflowInstances(List<Long> ids, List<String> types, Long parentWorkflowId, Long parentActionId, List<String> states, List<WorkflowInstance.WorkflowInstanceStatus> statuses, String businessKey, String externalId, String stateVariableKey, String stateVariableValue, String include, Long maxResults, Long maxActions, WorkflowInstanceService workflowInstances, ListWorkflowInstanceConverter listWorkflowConverter) {
        Set includeStrings = this.parseIncludeStrings(include).collect(Collectors.toSet());
        QueryWorkflowInstances q = new QueryWorkflowInstances.Builder().addIds(ids.toArray(new Long[ids.size()])).addTypes(types.toArray(new String[types.size()])).setParentWorkflowId(parentWorkflowId).setParentActionId(parentActionId).addStates(states.toArray(new String[states.size()])).addStatuses(statuses.toArray(new WorkflowInstance.WorkflowInstanceStatus[statuses.size()])).setBusinessKey(businessKey).setExternalId(externalId).setIncludeCurrentStateVariables(includeStrings.contains(currentStateVariables)).setIncludeActions(includeStrings.contains(actions)).setIncludeActionStateVariables(includeStrings.contains(actionStateVariables)).setMaxResults(maxResults).setMaxActions(maxActions).setIncludeChildWorkflows(includeStrings.contains(childWorkflows)).setStateVariable(stateVariableKey, stateVariableValue).build();
        Stream instances = workflowInstances.listWorkflowInstancesAsStream(q);
        Set<WorkflowInstanceInclude> parseIncludeEnums = this.parseIncludeEnums(include);
        return instances.map(instance -> listWorkflowConverter.convert((WorkflowInstance)instance, parseIncludeEnums));
    }

    private Set<WorkflowInstanceInclude> parseIncludeEnums(String include) {
        return this.parseIncludeStrings(include).map(INCLUDE_STRING_TO_ENUM::get).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    private Stream<String> parseIncludeStrings(String include) {
        return Stream.of(org.apache.commons.lang3.StringUtils.trimToEmpty((String)include).split(","));
    }

    public ListWorkflowInstanceResponse fetchWorkflowInstance(long id, String include, Long maxActions, WorkflowInstanceService workflowInstances, ListWorkflowInstanceConverter listWorkflowConverter) throws EmptyResultDataAccessException {
        Set<WorkflowInstanceInclude> includes = this.parseIncludeEnums(include);
        WorkflowInstance instance = workflowInstances.getWorkflowInstance(id, includes, maxActions);
        return listWorkflowConverter.convert(instance, includes);
    }

    protected int resolveExceptionHttpStatus(Throwable t) {
        if (t instanceof IllegalArgumentException) {
            return 400;
        }
        if (t instanceof NflowNotFoundException) {
            return 404;
        }
        return 500;
    }

    protected <T> T handleExceptions(Supplier<T> response, BiFunction<Integer, ErrorResponse, T> error) {
        try {
            return response.get();
        }
        catch (Throwable t) {
            int code = this.resolveExceptionHttpStatus(t);
            return error.apply(code, new ErrorResponse(t.getMessage()));
        }
    }
}

