/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.converter;

import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceResponse;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CreateWorkflowConverter {
    private final WorkflowInstanceFactory factory;

    @Inject
    public CreateWorkflowConverter(WorkflowInstanceFactory factory) {
        this.factory = factory;
    }

    public WorkflowInstance convert(CreateWorkflowInstanceRequest req) {
        WorkflowInstance.Builder builder = this.factory.newWorkflowInstanceBuilder().setType(req.type).setBusinessKey(req.businessKey).setExternalId(req.externalId);
        if (!Boolean.FALSE.equals(req.activate)) {
            if (req.activationTime != null) {
                builder.setNextActivation(req.activationTime);
            }
        } else {
            builder.setNextActivation(null);
        }
        builder.setParentWorkflowId(req.parentWorkflowId);
        if (StringUtils.isNotEmpty((CharSequence)req.startState)) {
            builder.setState(req.startState);
        }
        for (Map.Entry<String, Object> entry : req.stateVariables.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                builder.putStateVariable(entry.getKey(), (String)value);
                continue;
            }
            builder.putStateVariable(entry.getKey(), value);
        }
        return builder.build();
    }

    public CreateWorkflowInstanceResponse convert(WorkflowInstance instance) {
        CreateWorkflowInstanceResponse resp = new CreateWorkflowInstanceResponse();
        resp.id = instance.id;
        resp.type = instance.type;
        resp.businessKey = instance.businessKey;
        resp.externalId = instance.externalId;
        return resp;
    }
}

