/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.converter;

import io.nflow.engine.workflow.definition.WorkflowDefinitionStatistics;
import io.nflow.engine.workflow.statistics.Statistics;
import io.nflow.rest.v1.msg.StatisticsResponse;
import io.nflow.rest.v1.msg.WorkflowDefinitionStatisticsResponse;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class StatisticsConverter {
    public StatisticsResponse convert(Statistics stats) {
        StatisticsResponse response = new StatisticsResponse();
        response.queueStatistics.count = stats.queuedStatistics.count;
        response.queueStatistics.maxAge = stats.queuedStatistics.maxAgeMillis;
        response.queueStatistics.minAge = stats.queuedStatistics.minAgeMillis;
        response.executionStatistics.count = stats.executionStatistics.count;
        response.executionStatistics.maxAge = stats.executionStatistics.maxAgeMillis;
        response.executionStatistics.minAge = stats.executionStatistics.minAgeMillis;
        return response;
    }

    public WorkflowDefinitionStatisticsResponse convert(Map<String, Map<String, WorkflowDefinitionStatistics>> stats) {
        WorkflowDefinitionStatisticsResponse resp = new WorkflowDefinitionStatisticsResponse();
        for (Map.Entry<String, Map<String, WorkflowDefinitionStatistics>> entry : stats.entrySet()) {
            WorkflowDefinitionStatisticsResponse.StateStatistics stateStats = new WorkflowDefinitionStatisticsResponse.StateStatistics();
            resp.stateStatistics.put(entry.getKey(), stateStats);
            for (Map.Entry<String, WorkflowDefinitionStatistics> statusEntry : entry.getValue().entrySet()) {
                WorkflowDefinitionStatistics value = statusEntry.getValue();
                switch (statusEntry.getKey()) {
                    case "created": {
                        stateStats.created.allInstances = value.allInstances;
                        stateStats.created.queuedInstances = value.queuedInstances;
                        break;
                    }
                    case "inProgress": {
                        stateStats.inProgress.allInstances = value.allInstances;
                        stateStats.inProgress.queuedInstances = value.queuedInstances;
                        break;
                    }
                    case "executing": {
                        stateStats.executing.allInstances = value.allInstances;
                        break;
                    }
                    case "manual": {
                        stateStats.manual.allInstances = value.allInstances;
                        break;
                    }
                    case "finished": {
                        stateStats.finished.allInstances = value.allInstances;
                        break;
                    }
                }
            }
        }
        return resp;
    }
}

