/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.exemplar.AbstractFixedSizeExemplarReservoir;
import java.util.List;

final class HistogramBucketExemplarReservoir
extends AbstractFixedSizeExemplarReservoir {
    private final double[] boundaries;

    public static HistogramBucketExemplarReservoir create(Clock clock, List<Double> boundaries) {
        return new HistogramBucketExemplarReservoir(clock, ExplicitBucketHistogramUtils.createBoundaryArray(boundaries));
    }

    HistogramBucketExemplarReservoir(Clock clock, double[] boundaries) {
        super(clock, boundaries.length + 1);
        this.boundaries = boundaries;
    }

    @Override
    protected int reservoirIndexFor(double value, Attributes attributes, Context context) {
        return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
    }
}

