/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.instrument.BoundDoubleCounter;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkDoubleCounter
extends AbstractInstrument
implements DoubleCounter {
    private static final Logger logger = Logger.getLogger(SdkDoubleCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void add(double increment, Attributes attributes, Context context) {
        if (increment < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(increment, attributes, context);
    }

    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    BoundDoubleCounter bind(Attributes attributes) {
        return new BoundInstrument(this.getDescriptor(), this.storage.bind(attributes), attributes);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static final class BoundInstrument
    implements BoundDoubleCounter {
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(SdkDoubleCounter.access$000());
        private final InstrumentDescriptor descriptor;
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(InstrumentDescriptor descriptor, BoundStorageHandle handle, Attributes attributes) {
            this.descriptor = descriptor;
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(double increment, Context context) {
            if (increment < 0.0) {
                this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.descriptor.getName() + " has recorded a negative value.");
                return;
            }
            this.handle.recordDouble(increment, this.attributes, context);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class SdkDoubleCounterBuilder
    extends AbstractInstrumentBuilder<SdkDoubleCounterBuilder>
    implements DoubleCounterBuilder {
        SdkDoubleCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, InstrumentType.COUNTER, InstrumentValueType.DOUBLE, name, description, unit);
        }

        @Override
        protected SdkDoubleCounterBuilder getThis() {
            return this;
        }

        public SdkDoubleCounter build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, callback);
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }
    }
}

