/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import io.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import io.opentelemetry.sdk.metrics.internal.view.SumAggregation;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DefaultAggregation.class.getName()));

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrument, boolean withAdvice) {
        switch (instrument.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return SumAggregation.getInstance();
            }
            case HISTOGRAM: {
                if (withAdvice && instrument.getAdvice().getExplicitBucketBoundaries() != null) {
                    return ExplicitBucketHistogramAggregation.create(instrument.getAdvice().getExplicitBucketBoundaries());
                }
                return ExplicitBucketHistogramAggregation.getDefault();
            }
            case OBSERVABLE_GAUGE: {
                return LastValueAggregation.getInstance();
            }
        }
        logger.log(Level.WARNING, "Unable to find default aggregation for instrument: " + instrument);
        return DropAggregation.getInstance();
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, true))).createAggregator(instrumentDescriptor, exemplarFilter, memoryMode);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, false))).isCompatibleWithInstrument(instrumentDescriptor);
    }

    public String toString() {
        return "DefaultAggregation";
    }
}

