/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.util;

import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.util.ThreadLocalActiveSpanSource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLocalActiveSpan
implements ActiveSpan {
    private final ThreadLocalActiveSpanSource source;
    private final Span wrapped;
    private final ThreadLocalActiveSpan toRestore;
    private final AtomicInteger refCount;

    ThreadLocalActiveSpan(ThreadLocalActiveSpanSource source, Span wrapped, AtomicInteger refCount) {
        this.source = source;
        this.refCount = refCount;
        this.wrapped = wrapped;
        this.toRestore = source.tlsSnapshot.get();
        source.tlsSnapshot.set(this);
    }

    public void deactivate() {
        if (this.source.tlsSnapshot.get() != this) {
            return;
        }
        this.source.tlsSnapshot.set(this.toRestore);
        if (0 == this.refCount.decrementAndGet()) {
            this.wrapped.finish();
        }
    }

    public Continuation capture() {
        return new Continuation();
    }

    public SpanContext context() {
        return this.wrapped.context();
    }

    public ThreadLocalActiveSpan setTag(String key, String value) {
        this.wrapped.setTag(key, value);
        return this;
    }

    public ThreadLocalActiveSpan setTag(String key, boolean value) {
        this.wrapped.setTag(key, value);
        return this;
    }

    public ThreadLocalActiveSpan setTag(String key, Number value) {
        this.wrapped.setTag(key, value);
        return this;
    }

    public ThreadLocalActiveSpan log(Map<String, ?> fields) {
        this.wrapped.log(fields);
        return this;
    }

    public ThreadLocalActiveSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        this.wrapped.log(timestampMicroseconds, fields);
        return this;
    }

    public ThreadLocalActiveSpan log(String event) {
        this.wrapped.log(event);
        return this;
    }

    public ThreadLocalActiveSpan log(long timestampMicroseconds, String event) {
        this.wrapped.log(timestampMicroseconds, event);
        return this;
    }

    public ThreadLocalActiveSpan setBaggageItem(String key, String value) {
        this.wrapped.setBaggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.wrapped.getBaggageItem(key);
    }

    public ThreadLocalActiveSpan setOperationName(String operationName) {
        this.wrapped.setOperationName(operationName);
        return this;
    }

    public ThreadLocalActiveSpan log(String eventName, Object payload) {
        this.wrapped.log(eventName, payload);
        return this;
    }

    public ThreadLocalActiveSpan log(long timestampMicroseconds, String eventName, Object payload) {
        this.wrapped.log(timestampMicroseconds, eventName, payload);
        return this;
    }

    public void close() {
        this.deactivate();
    }

    private final class Continuation
    implements ActiveSpan.Continuation {
        Continuation() {
            ThreadLocalActiveSpan.this.refCount.incrementAndGet();
        }

        public ThreadLocalActiveSpan activate() {
            return new ThreadLocalActiveSpan(ThreadLocalActiveSpan.this.source, ThreadLocalActiveSpan.this.wrapped, ThreadLocalActiveSpan.this.refCount);
        }
    }
}

