/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.http.HttpTracing;
import java.util.function.Function;
import reactor.netty.http.brave.TracingHttpClientDecorator;
import reactor.netty.http.brave.TracingHttpServerDecorator;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.server.HttpServer;

public final class ReactorNettyHttpTracing {
    final TracingHttpClientDecorator httpClientDecorator;
    final TracingHttpServerDecorator httpServerDecorator;

    public static ReactorNettyHttpTracing create(HttpTracing httpTracing) {
        return ReactorNettyHttpTracing.create(httpTracing, Function.identity());
    }

    public static ReactorNettyHttpTracing create(HttpTracing httpTracing, Function<String, String> uriMapping) {
        return new ReactorNettyHttpTracing(httpTracing, uriMapping);
    }

    ReactorNettyHttpTracing(HttpTracing httpTracing, Function<String, String> uriMapping) {
        this.httpClientDecorator = new TracingHttpClientDecorator(httpTracing, uriMapping);
        this.httpServerDecorator = new TracingHttpServerDecorator(httpTracing, uriMapping);
    }

    public HttpClient decorateHttpClient(HttpClient client) {
        return this.httpClientDecorator.decorate(client);
    }

    public HttpServer decorateHttpServer(HttpServer server) {
        return this.httpServerDecorator.decorate(server);
    }
}

