/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics;

import io.quarkus.analytics.AnonymousUserId;
import io.quarkus.analytics.ConfigService;
import io.quarkus.analytics.config.ExtensionsFilter;
import io.quarkus.analytics.config.FileLocations;
import io.quarkus.analytics.dto.config.Identity;
import io.quarkus.analytics.dto.segment.ContextBuilder;
import io.quarkus.analytics.dto.segment.Track;
import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.analytics.dto.segment.TrackProperties;
import io.quarkus.analytics.rest.RestClient;
import io.quarkus.analytics.util.FileUtils;
import io.quarkus.analytics.util.PropertyUtils;
import io.quarkus.analytics.util.StringUtils;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AnalyticsService
implements AutoCloseable {
    private final Queue<CompletableFuture<HttpResponse<String>>> postFutures;
    private final RestClient restClient;
    private final ConfigService config;
    private final AnonymousUserId anonymousUserId;
    private final MessageWriter log;
    final FileLocations fileLocations;

    public AnalyticsService(FileLocations fileLocations, MessageWriter log) {
        this.fileLocations = fileLocations;
        if (log == null) {
            this.log = MessageWriter.info();
            this.log.info("No logger provided, using default");
        } else {
            this.log = log;
        }
        this.postFutures = new ConcurrentLinkedQueue<CompletableFuture<HttpResponse<String>>>();
        this.restClient = new RestClient(this.log);
        this.anonymousUserId = AnonymousUserId.getInstance(fileLocations, this.log);
        this.config = new ConfigService(this.restClient, this.anonymousUserId, fileLocations, this.log);
    }

    public void buildAnalyticsUserInput(Function<String, String> analyticsEnabledSupplier) {
        this.config.userAcceptance(analyticsEnabledSupplier);
    }

    public void sendAnalytics(TrackEventType trackEventType, ApplicationModel applicationModel, Map<String, Object> buildInfo, File localBuildDir) {
        if (this.config.isActive() && this.config.isArtifactActive(applicationModel.getAppArtifact().getGroupId(), this.getQuarkusVersion(applicationModel))) {
            Map<String, Object> context = this.createContextMap(applicationModel, buildInfo);
            this.sendIdentity(context);
            Track trackEvent = Track.builder().userId(this.anonymousUserId.getUuid()).context(context).event(trackEventType).properties(TrackProperties.builder().appExtensions(this.createExtensionsPropertyValue(applicationModel)).build()).timestamp(Instant.now()).build();
            this.postFutures.add(this.restClient.postTrack(trackEvent));
            try {
                FileUtils.overwrite(trackEvent, Path.of(localBuildDir.getAbsolutePath(), this.fileLocations.lastTrackFileName()));
            }
            catch (IOException e) {
                this.log.warn("[Quarkus build analytics] Failed to write the last analytics file. " + e.getMessage());
            }
        }
    }

    @Override
    public void close() {
        block5: {
            try {
                CompletableFuture.allOf(this.postFutures.toArray(new CompletableFuture[0])).get(PropertyUtils.getProperty("quarkus.analytics.timeout", 3000).intValue(), TimeUnit.MILLISECONDS);
                if (this.log.isDebugEnabled() && !this.postFutures.isEmpty()) {
                    this.log.debug("[Quarkus build analytics] Build analytics sent successfully. Sent event can be seen at .../target/" + this.fileLocations.lastTrackFileName());
                }
            }
            catch (ExecutionException | TimeoutException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[Quarkus build analytics] Failed to send build analytics to Segment. Connection might not be available or is too slow: " + e.getClass().getName() + ": " + (e.getMessage() == null ? "(no message)" : e.getMessage()));
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("[Quarkus build analytics] Failed to send build analytics to Segment: " + e.getClass().getName() + ": " + (e.getMessage() == null ? "(no message)" : e.getMessage()));
            }
        }
    }

    List<TrackProperties.AppExtension> createExtensionsPropertyValue(ApplicationModel applicationModel) {
        return applicationModel.getDependencies().stream().filter(dep -> dep.isResolved() && dep.isFlagSet(128) && ExtensionsFilter.onlyPublic(dep.getGroupId(), this.log)).map(dep -> TrackProperties.AppExtension.builder().groupId(dep.getGroupId()).artifactId(dep.getArtifactId()).version(dep.getVersion()).build()).collect(Collectors.toList());
    }

    void sendIdentity(Map<String, Object> context) {
        if (this.anonymousUserId.isNew()) {
            this.restClient.postIdentity(Identity.builder().userId(this.anonymousUserId.getUuid()).context(context).timestamp(Instant.now()).build());
        }
    }

    Map<String, Object> createContextMap(ApplicationModel applicationModel, Map<String, Object> buildInfo) {
        ResolvedDependency moduleId = applicationModel.getAppArtifact();
        return new ContextBuilder().mapPair("app").pair("name", StringUtils.hashSHA256(moduleId.getGroupId() + ":" + moduleId.getArtifactId())).pair("version", StringUtils.hashSHA256(moduleId.getArtifactId() + ":" + moduleId.getVersion())).build().mapPair("java").pair("vendor", System.getProperty("java.vendor", "N/A")).pair("version", System.getProperty("java.version", "N/A")).build().mapPair("graalvm").pair("vendor", Optional.ofNullable(buildInfo.get("graalvm.version.distribution")).orElse("N/A")).pair("version", Optional.ofNullable(buildInfo.get("graalvm.version.version")).orElse("N/A")).pair("java_version", Optional.ofNullable(buildInfo.get("graalvm.version.java")).orElse("N/A")).build().mapPair("build").pair("maven_version", Optional.ofNullable(buildInfo.get("maven.version")).orElse("N/A")).pair("gradle_version", Optional.ofNullable(buildInfo.get("gradle.version")).orElse("N/A")).build().mapPair("quarkus").pair("version", this.getQuarkusVersion(applicationModel)).build().pair("ip", "0.0.0.0").mapPair("location").pair("locale_country", Locale.getDefault().getCountry()).build().mapPair("os").pair("name", System.getProperty("os.name", "N/A")).pair("version", System.getProperty("os.version", "N/A")).pair("os_arch", System.getProperty("os.arch", "N/A")).build().mapPair("ci").pair("name", this.getBuildSystemName()).build().mapPair("kubernetes").pair("detected", this.isKubernetesDetected()).build().pair("timezone", ZoneId.systemDefault().getDisplayName(TextStyle.NARROW, Locale.ENGLISH)).build();
    }

    private String isKubernetesDetected() {
        return Boolean.toString(this.allEnvSet("KUBERNETES_SERVICE_HOST", "KUBERNETES_SERVICE_PORT"));
    }

    private String getBuildSystemName() {
        String travis = System.getenv("TRAVIS");
        String user = System.getenv("USER");
        if ("true".equals(travis) && "travis".equals(user)) {
            return "travis";
        }
        if (this.allEnvSet("JENKINS_URL", "JENKINS_HOME", "WORKSPACE")) {
            return "jenkins";
        }
        if (this.allEnvSet("GITHUB_WORKFLOW", "GITHUB_WORKSPACE", "GITHUB_RUN_ID")) {
            return "github-actions";
        }
        if (this.allEnvSet("BUILD_REASON", "AGENT_JOBSTATUS")) {
            return "azure-pipelines";
        }
        return "unknown";
    }

    private boolean allEnvSet(String ... names) {
        for (String name : names) {
            if (System.getenv(name) != null) continue;
            return false;
        }
        return true;
    }

    private String getQuarkusVersion(ApplicationModel applicationModel) {
        return applicationModel.getPlatforms().getImportedPlatformBoms().stream().filter(artifactCoords -> artifactCoords.getArtifactId().equals("quarkus-bom")).map(ArtifactCoords::getVersion).findFirst().orElse("N/A");
    }
}

