/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.RequestFlyweight;

public class PayloadFrameFlyweight {
    private static final RequestFlyweight FLYWEIGHT = new RequestFlyweight(FrameType.PAYLOAD);

    private PayloadFrameFlyweight() {
    }

    public static ByteBuf encodeNextReleasingPayload(ByteBufAllocator allocator, int streamId, Payload payload) {
        return PayloadFrameFlyweight.encodeReleasingPayload(allocator, streamId, false, payload);
    }

    public static ByteBuf encodeNextCompleteReleasingPayload(ByteBufAllocator allocator, int streamId, Payload payload) {
        return PayloadFrameFlyweight.encodeReleasingPayload(allocator, streamId, true, payload);
    }

    static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, int streamId, boolean complete, Payload payload) {
        ByteBuf data;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata().retain() : null;
        try {
            data = payload.data().retain();
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            data.release();
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        return PayloadFrameFlyweight.encode(allocator, streamId, false, complete, true, metadata, data);
    }

    public static ByteBuf encodeComplete(ByteBufAllocator allocator, int streamId) {
        return PayloadFrameFlyweight.encode(allocator, streamId, false, true, false, null, null);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, boolean fragmentFollows, boolean complete, boolean next, ByteBuf metadata, ByteBuf data) {
        return FLYWEIGHT.encode(allocator, streamId, fragmentFollows, complete, next, 0, metadata, data);
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        return FLYWEIGHT.data(byteBuf);
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        return FLYWEIGHT.metadata(byteBuf);
    }
}

