/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.lease.Lease;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LeaseImpl
implements Lease {
    private final int timeToLiveMillis;
    private final AtomicInteger allowedRequests;
    private final int startingAllowedRequests;
    private final ByteBuf metadata;
    private final long expiry;

    static LeaseImpl create(int timeToLiveMillis, int numberOfRequests, @Nullable ByteBuf metadata) {
        LeaseImpl.assertLease(timeToLiveMillis, numberOfRequests);
        return new LeaseImpl(timeToLiveMillis, numberOfRequests, metadata);
    }

    static LeaseImpl empty() {
        return new LeaseImpl(0, 0, null);
    }

    private LeaseImpl(int timeToLiveMillis, int allowedRequests, @Nullable ByteBuf metadata) {
        this.allowedRequests = new AtomicInteger(allowedRequests);
        this.startingAllowedRequests = allowedRequests;
        this.timeToLiveMillis = timeToLiveMillis;
        this.metadata = metadata == null ? Unpooled.EMPTY_BUFFER : metadata;
        this.expiry = timeToLiveMillis == 0 ? 0L : LeaseImpl.now() + (long)timeToLiveMillis;
    }

    @Override
    public int getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    @Override
    public int getAllowedRequests() {
        return Math.max(0, this.allowedRequests.get());
    }

    @Override
    public int getStartingAllowedRequests() {
        return this.startingAllowedRequests;
    }

    @Override
    @Nonnull
    public ByteBuf getMetadata() {
        return this.metadata;
    }

    @Override
    public long expiry() {
        return this.expiry;
    }

    @Override
    public boolean isValid() {
        return !this.isEmpty() && this.getAllowedRequests() > 0 && !this.isExpired();
    }

    public boolean use() {
        if (this.isExpired()) {
            return false;
        }
        int remaining = this.allowedRequests.accumulateAndGet(1, (cur, update) -> Math.max(-1, cur - update));
        return remaining >= 0;
    }

    @Override
    public double availability() {
        return this.isValid() ? (double)this.getAllowedRequests() / (double)this.getStartingAllowedRequests() : 0.0;
    }

    public String toString() {
        long now = LeaseImpl.now();
        return "LeaseImpl{timeToLiveMillis=" + this.timeToLiveMillis + ", allowedRequests=" + this.getAllowedRequests() + ", startingAllowedRequests=" + this.startingAllowedRequests + ", expired=" + this.isExpired(now) + ", remainingTimeToLiveMillis=" + this.getRemainingTimeToLiveMillis(now) + '}';
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static void assertLease(int timeToLiveMillis, int numberOfRequests) {
        if (numberOfRequests <= 0) {
            throw new IllegalArgumentException("Number of requests must be positive");
        }
        if (timeToLiveMillis <= 0) {
            throw new IllegalArgumentException("Time-to-live must be positive");
        }
    }
}

