/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.fragmentation.ReassemblyDuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.TcpDuplexConnection;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpServer;

public final class TcpServerTransport
implements ServerTransport<CloseableChannel> {
    private final TcpServer server;

    private TcpServerTransport(TcpServer server) {
        this.server = server;
    }

    public static TcpServerTransport create(int port) {
        TcpServer server = TcpServer.create().port(port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpServer server = TcpServer.create().host(bindAddress).port(port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        return TcpServerTransport.create(address.getHostName(), address.getPort());
    }

    public static TcpServerTransport create(TcpServer server) {
        Objects.requireNonNull(server, "server must not be null");
        return new TcpServerTransport(server);
    }

    public Mono<CloseableChannel> start(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        Mono isError = FragmentationDuplexConnection.checkMtu((int)mtu);
        return isError != null ? isError : this.server.doOnConnection(c -> {
            c.addHandlerLast((ChannelHandler)new RSocketLengthCodec());
            Object connection = mtu > 0 ? new FragmentationDuplexConnection((DuplexConnection)new TcpDuplexConnection((Connection)c, false), mtu, true, "server") : new ReassemblyDuplexConnection((DuplexConnection)new TcpDuplexConnection((Connection)c), false);
            acceptor.apply((DuplexConnection)connection).then(Mono.never()).subscribe(c.disposeSubscriber());
        }).bind().map(CloseableChannel::new);
    }
}

